/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.tx;

import java.util.List;
import java.util.Optional;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.spi.domain.generator.InterceptorGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.physical.PhysicalInterceptor;
import org.fabric3.tx.PhysicalTxInterceptor;
import org.fabric3.tx.TxAction;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class TxInterceptorGenerator
implements InterceptorGenerator {
    private static final Optional<PhysicalInterceptor> PHYSICAL_INTERCEPTOR = Optional.of(new PhysicalTxInterceptor(TxAction.BEGIN));

    public Optional<PhysicalInterceptor> generate(LogicalOperation source, LogicalOperation target) {
        ComponentType componentType = ((LogicalComponent)((LogicalInvocable)target.getParent()).getParent()).getDefinition().getImplementation().getComponentType();
        List policies = componentType.getPolicies();
        if (!policies.isEmpty() && this.containsPolicy(policies)) {
            return PHYSICAL_INTERCEPTOR;
        }
        return Optional.empty();
    }

    private boolean containsPolicy(List<String> policies) {
        return policies.contains("managedTransaction") || policies.contains("managedTransaction.local") || policies.contains("managedTransaction.global");
    }
}

