/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.spi.container.builder.ComponentBuilderListener;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalComponent;
import org.fabric3.spi.monitor.MonitorLocator;
import org.fabric3.spi.monitor.MonitorService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@EagerInit
@Management(name="MonitorService", path="/runtime/monitor", description="Sets monitoring levels for the runtime")
@Service(value={MonitorService.class, ComponentBuilderListener.class})
public class MonitorServiceImpl
implements MonitorService,
ComponentBuilderListener {
    private ComponentManager manager;
    private Map<URI, MonitorLevel> applicationComponentLevels = Collections.emptyMap();
    private Map<URI, MonitorLevel> runtimeComponentLevels = Collections.emptyMap();
    private Map<String, MonitorLevel> providerLevels = new ConcurrentHashMap<String, MonitorLevel>();
    private Map<URI, MonitorLevel> contributionLevels = new ConcurrentHashMap<URI, MonitorLevel>();
    private MonitorLevel defaultLevel = MonitorLevel.INFO;

    public MonitorServiceImpl(@Reference ComponentManager manager, @Reference HostInfo info) {
        this.manager = manager;
        MonitorLocator.setInstance((MonitorService)this);
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:runtime/@monitor.level")
    public void setDefaultLevel(String defaultLevel) {
        try {
            this.defaultLevel = MonitorLevel.valueOf((String)defaultLevel.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid monitor level value: " + defaultLevel);
        }
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:runtime/f3:monitor/f3:contribution.levels")
    public void setContributionLevels(Element levels) {
        NodeList list = levels.getElementsByTagName("level");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String name = element.getAttribute("name");
            String level = element.getAttribute("value");
            this.setContributionLevel(name, level);
        }
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:runtime/f3:monitor/f3:provider.levels")
    public void setProviderLevels(Element levels) {
        NodeList list = levels.getElementsByTagName("level");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            String name = element.getAttribute("name");
            String level = element.getAttribute("value");
            this.setProviderLevel(name, level);
        }
    }

    @Init
    public void init() {
        for (Component component : this.manager.getComponents()) {
            component.setLevel(this.defaultLevel);
        }
        for (Map.Entry entry : this.contributionLevels.entrySet()) {
            for (Component component : this.manager.getDeployedComponents((URI)entry.getKey())) {
                component.setLevel((MonitorLevel)entry.getValue());
            }
        }
        for (Map.Entry entry : this.applicationComponentLevels.entrySet()) {
            for (Component component : this.manager.getComponentsInHierarchy((URI)entry.getKey())) {
                component.setLevel((MonitorLevel)entry.getValue());
            }
        }
        for (Map.Entry entry : this.runtimeComponentLevels.entrySet()) {
            for (Component component : this.manager.getComponentsInHierarchy((URI)entry.getKey())) {
                component.setLevel((MonitorLevel)entry.getValue());
            }
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a component")
    public void setComponentLevel(String uri, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level.toUpperCase());
        List components = this.manager.getComponentsInHierarchy(URI.create(uri));
        for (Component component : components) {
            component.setLevel(parsed);
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a provider")
    public void setProviderLevel(String key, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level.toUpperCase());
        this.providerLevels.put(key, parsed);
    }

    public MonitorLevel getProviderLevel(String key) {
        return this.providerLevels.get(key);
    }

    @ManagementOperation(description="Sets the monitoring level for a contribution or extension")
    public void setContributionLevel(String key, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level.toUpperCase());
        URI uri = URI.create(key);
        this.contributionLevels.put(uri, parsed);
        for (Component component : this.manager.getComponents()) {
            if (!uri.equals(component.getContributionUri())) continue;
            component.setLevel(parsed);
        }
    }

    public void onBuild(Component component, PhysicalComponent physicalComponent) {
        if (MonitorLevel.INFO != this.defaultLevel) {
            component.setLevel(this.defaultLevel);
        }
        String strUri = component.getUri().toString();
        for (Map.Entry<URI, MonitorLevel> entry : this.runtimeComponentLevels.entrySet()) {
            if (!strUri.startsWith(entry.getKey().toString())) continue;
            component.setLevel(entry.getValue());
            return;
        }
        for (Map.Entry<URI, MonitorLevel> entry : this.applicationComponentLevels.entrySet()) {
            if (!strUri.startsWith(entry.getKey().toString())) continue;
            component.setLevel(entry.getValue());
            return;
        }
        MonitorLevel level = this.contributionLevels.get(component.getContributionUri());
        if (level != null) {
            component.setLevel(level);
        }
    }

    public void onDispose(Component component, PhysicalComponent physicalComponent) {
    }
}

