/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.api.MonitorChannel;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.spi.monitor.DispatchInfo;
import org.fabric3.spi.monitor.MonitorProxy;

public class JDKMonitorHandler
implements InvocationHandler,
MonitorChannel,
MonitorProxy {
    private DestinationRouter router;
    private int destinationIndex;
    private Monitorable monitorable;
    private String source;
    private Map<Method, DispatchInfo> infos;
    private MonitorLevel level;
    private String template;

    public JDKMonitorHandler(int destinationIndex, Monitorable monitorable, DestinationRouter router, Map<Method, DispatchInfo> infos) {
        this.destinationIndex = destinationIndex;
        this.monitorable = monitorable;
        this.router = router;
        this.source = monitorable.getName();
        this.infos = infos;
        if (infos.size() == 1) {
            DispatchInfo info = infos.values().iterator().next();
            this.level = info.getLevel();
            this.template = info.getMessage();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String currentMessage;
        MonitorLevel currentLevel;
        if (args != null && args.length > 10) {
            throw new UnsupportedOperationException("Unsupported number of monitor arguments: " + args.length);
        }
        if (this.level != null) {
            currentLevel = this.level;
            currentMessage = this.template;
        } else {
            DispatchInfo info = this.infos.get(method);
            currentLevel = info.getLevel();
            currentMessage = info.getMessage();
        }
        if (currentLevel == null || currentLevel.intValue() < this.monitorable.getLevel().intValue()) {
            return null;
        }
        long timestamp = System.currentTimeMillis();
        this.send(currentLevel, timestamp, currentMessage, true, args);
        return null;
    }

    public void severe(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.SEVERE, message, args);
    }

    public void warn(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.WARNING, message, args);
    }

    public void info(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.INFO, message, args);
    }

    public void debug(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.DEBUG, message, args);
    }

    public void trace(String message, Object ... args) {
        this.checkAndSend(MonitorLevel.TRACE, message, args);
    }

    public void send(MonitorLevel level, long timestamp, String template, boolean parse, Object[] args) {
        if (args == null) {
            this.router.send(level, this.destinationIndex, timestamp, this.source, template, parse, new Object[]{template});
        } else {
            this.router.send(level, this.destinationIndex, timestamp, this.source, template, parse, args);
        }
    }

    private void checkAndSend(MonitorLevel level, String message, Object[] args) {
        if (level.intValue() < this.monitorable.getLevel().intValue()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.send(level, timestamp, message, true, args);
    }
}

