/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionProcessor;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.xml.XmlIndexerRegistry;
import org.fabric3.spi.contribution.xml.XmlProcessorRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class XmlContributionProcessor
implements ContributionProcessor {
    private static final String CONTENT_TYPE = "application/xml";
    private XMLInputFactory xmlFactory;
    private ProcessorRegistry processorRegistry;
    private XmlProcessorRegistry xmlProcessorRegistry;
    private XmlIndexerRegistry xmlIndexerRegistry;

    public XmlContributionProcessor(@Reference ProcessorRegistry processorRegistry, @Reference XmlProcessorRegistry xmlProcessorRegistry, @Reference XmlIndexerRegistry xmlIndexerRegistry) {
        this.processorRegistry = processorRegistry;
        this.xmlProcessorRegistry = xmlProcessorRegistry;
        this.xmlIndexerRegistry = xmlIndexerRegistry;
        this.xmlFactory = XMLInputFactory.newFactory();
    }

    @Init
    public void init() {
        this.processorRegistry.register((ContributionProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.processorRegistry.unregister((ContributionProcessor)this);
    }

    public boolean canProcess(Contribution contribution) {
        return CONTENT_TYPE.equals(contribution.getContentType());
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void index(Contribution contribution, IntrospectionContext context) {
        InputStream stream = null;
        XMLStreamReader reader = null;
        try {
            URL locationURL = contribution.getLocation();
            stream = locationURL.openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            reader.nextTag();
            URL url = contribution.getLocation();
            UrlSource source = new UrlSource(url);
            Resource resource = new Resource(contribution, (Source)source, CONTENT_TYPE);
            this.xmlIndexerRegistry.index(resource, reader, context);
            contribution.addResource(resource);
            this.close(stream, reader);
            return;
        }
        catch (IOException e) {
            try {
                String uri = contribution.getUri().toString();
                throw new Fabric3Exception("Error processing contribution " + uri, (Throwable)e);
                catch (XMLStreamException e2) {
                    uri = contribution.getUri().toString();
                    if (e2.getLocation() == null) {
                        throw new Fabric3Exception("Error processing contribution " + uri, (Throwable)e2);
                    }
                    int line = e2.getLocation().getLineNumber();
                    int col = e2.getLocation().getColumnNumber();
                    throw new Fabric3Exception("Error processing contribution " + uri + " [" + line + "," + col + "]", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.close(stream, reader);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(Contribution contribution, IntrospectionContext context) {
        URL locationURL = contribution.getLocation();
        InputStream stream = null;
        XMLStreamReader reader = null;
        try {
            stream = locationURL.openStream();
            reader = this.xmlFactory.createXMLStreamReader(stream);
            reader.nextTag();
            this.xmlProcessorRegistry.process(contribution, reader, context);
            this.close(stream, reader);
            return;
        }
        catch (IOException e) {
            try {
                String uri = contribution.getUri().toString();
                throw new Fabric3Exception("Error processing contribution " + uri, (Throwable)e);
                catch (XMLStreamException e2) {
                    uri = contribution.getUri().toString();
                    int line = e2.getLocation().getLineNumber();
                    int col = e2.getLocation().getColumnNumber();
                    throw new Fabric3Exception("Error processing contribution " + uri + " [" + line + "," + col + "]", (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.close(stream, reader);
                throw throwable;
            }
        }
    }

    private void close(InputStream stream, XMLStreamReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

