/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.contribution.ClasspathProcessor;
import org.fabric3.spi.contribution.ClasspathProcessorRegistry;
import org.fabric3.spi.contribution.Contribution;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SymLinkClasspathProcessor
implements ClasspathProcessor {
    private static final String F3_SYMLINK = "f3.symlink";
    private final ClasspathProcessorRegistry registry;

    public SymLinkClasspathProcessor(@Reference ClasspathProcessorRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void init() {
        this.registry.register((ClasspathProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.registry.unregister((ClasspathProcessor)this);
    }

    public boolean canProcess(Contribution contribution) {
        String sourceUrl = contribution.getLocation().toString();
        return sourceUrl.endsWith(".contribution") || contribution.getMetaData(Boolean.class, (Object)F3_SYMLINK) != null;
    }

    public List<URL> process(Contribution contribution) throws Fabric3Exception {
        URL url = contribution.getLocation();
        ArrayList<URL> classpath = new ArrayList<URL>();
        try {
            this.addToClasspath(url, classpath);
            for (URL additional : contribution.getAdditionalLocations()) {
                this.addToClasspath(additional, classpath);
            }
            return classpath;
        }
        catch (IOException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private void addToClasspath(URL url, List<URL> classpath) throws IOException {
        File webInfClasses;
        File webInfLib;
        File root = new File(url.getFile());
        File metaInfLib = new File(root, "META-INF" + File.separator + "lib");
        boolean isResources = false;
        if (metaInfLib.exists()) {
            classpath.add(metaInfLib.toURI().toURL());
            isResources = true;
        }
        if ((webInfLib = new File(root, "WEB-INF" + File.separator + "lib")).exists()) {
            classpath.add(webInfLib.toURI().toURL());
            isResources = true;
        }
        if ((webInfClasses = new File(root, "WEB-INF" + File.separator + "classes")).exists()) {
            classpath.add(webInfClasses.toURI().toURL());
            isResources = true;
        }
        if (!isResources) {
            classpath.add(url);
        }
    }
}

