/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.processor;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.contribution.manifest.QNameExport;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.contribution.xml.XmlProcessor;
import org.fabric3.spi.contribution.xml.XmlProcessorRegistry;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;

@EagerInit
public class ConfigProcessor
implements XmlProcessor {
    private static final QName TYPE = new QName("urn:fabric3.org", "config");
    private LoaderHelper loaderHelper;
    private XmlProcessorRegistry processorRegistry;

    public ConfigProcessor(@Reference XmlProcessorRegistry processorRegistry, @Reference LoaderHelper loaderHelper) {
        this.processorRegistry = processorRegistry;
        this.loaderHelper = loaderHelper;
    }

    @Init
    public void init() {
        this.processorRegistry.register((XmlProcessor)this);
    }

    @Destroy
    public void destroy() {
        this.processorRegistry.unregister(TYPE);
    }

    public QName getType() {
        return TYPE;
    }

    public void processContent(Contribution contribution, XMLStreamReader reader, IntrospectionContext context) {
        try {
            String localName = reader.getAttributeValue(null, "name");
            String targetNamespace = reader.getAttributeValue(null, "targetNamespace");
            Document value = this.loaderHelper.loadPropertyValues(reader);
            QName name = new QName(targetNamespace, "F3Synthetic" + localName);
            Property property = new Property(localName);
            property.setDefaultValue(value);
            Composite composite = new Composite(name);
            composite.add(property);
            Resource resource = new Resource(contribution, null, "application/xml");
            QNameSymbol symbol = new QNameSymbol(name);
            ResourceElement element = new ResourceElement((Symbol)symbol);
            element.setValue((Object)composite);
            resource.addResourceElement(element);
            resource.setState(ResourceState.PROCESSED);
            contribution.addResource(resource);
            ContributionManifest manifest = contribution.getManifest();
            Deployable deployable = new Deployable(name);
            manifest.addDeployable(deployable);
            QNameExport export = new QNameExport(targetNamespace);
            manifest.addExport((Export)export);
        }
        catch (XMLStreamException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }
}

