/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.contribution.manifest.MissingManifestAttribute;
import org.fabric3.spi.contribution.manifest.QNameImport;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class QNameImportLoader
extends AbstractValidatingTypeLoader<QNameImport> {
    public QNameImportLoader() {
        this.addAttributes(new String[]{"namespace", "location"});
    }

    public QNameImport load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        this.validateAttributes(reader, context, new ModelObject[0]);
        String ns = reader.getAttributeValue(null, "namespace");
        if (ns == null) {
            MissingManifestAttribute failure = new MissingManifestAttribute("The namespace attribute must be specified", startLocation);
            context.addError((ValidationFailure)failure);
            return null;
        }
        URI locationUri = null;
        String location = reader.getAttributeValue(null, "location");
        if (location != null) {
            try {
                locationUri = new URI(location);
            }
            catch (URISyntaxException e) {
                InvalidValue error = new InvalidValue("Invalid location attribute", startLocation, (Throwable)e, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        return new QNameImport(ns, locationUri);
    }
}

