/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.fabric3.api.host.Version;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.contribution.manifest.InvalidOSGiManifest;
import org.fabric3.contribution.manifest.OSGiManifestEntryParser;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.manifest.JarManifestHandler;
import org.fabric3.spi.contribution.manifest.JavaExport;
import org.fabric3.spi.contribution.manifest.JavaImport;
import org.fabric3.spi.contribution.manifest.PackageInfo;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class OSGiManifestHandler
implements JarManifestHandler {
    private static final String IMPORT_HEADER = "Import-Package";
    private static final String EXPORT_HEADER = "Export-Package";
    private static final String VERSION = "version=";
    private static final String RESOLUTION = "resolution:=";

    public void processManifest(ContributionManifest contributionManifest, Manifest jarManifest, IntrospectionContext context) {
        Attributes attributes = jarManifest.getMainAttributes();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            if (entry.getKey().toString().equalsIgnoreCase(IMPORT_HEADER)) {
                List<JavaImport> imports = this.parseImportHeader(entry.getValue().toString(), context);
                if (imports == null) {
                    return;
                }
                for (JavaImport imprt : imports) {
                    contributionManifest.addImport((Import)imprt);
                }
                continue;
            }
            if (!entry.getKey().toString().equalsIgnoreCase(EXPORT_HEADER)) continue;
            List<JavaExport> exports = this.parseExportHeader(entry.getValue().toString(), context);
            if (exports == null) {
                return;
            }
            for (JavaExport export : exports) {
                contributionManifest.addExport((Export)export);
            }
        }
    }

    private List<JavaImport> parseImportHeader(String header, IntrospectionContext context) {
        OSGiManifestEntryParser parser = new OSGiManifestEntryParser(header);
        ArrayList<JavaImport> imports = new ArrayList<JavaImport>();
        PackageInfo info = null;
        while (true) {
            OSGiManifestEntryParser.EventType type = parser.next();
            switch (type) {
                case BEGIN: {
                    break;
                }
                case PATH: {
                    info = new PackageInfo(parser.getText());
                    break;
                }
                case PARAMETER: {
                    String text = parser.getText();
                    if (text.startsWith(VERSION)) {
                        if (this.parseVersion(text, info, context)) break;
                        return null;
                    }
                    if (!text.startsWith(RESOLUTION)) break;
                    String val = text.substring(RESOLUTION.length());
                    info.setRequired("required".equalsIgnoreCase(val));
                    break;
                }
                case END_CLAUSE: {
                    if (info == null) break;
                    JavaImport imprt = new JavaImport(info);
                    imports.add(imprt);
                    break;
                }
                case END: {
                    return imports;
                }
            }
        }
    }

    private List<JavaExport> parseExportHeader(String header, IntrospectionContext context) {
        OSGiManifestEntryParser parser = new OSGiManifestEntryParser(header);
        ArrayList<JavaExport> exports = new ArrayList<JavaExport>();
        PackageInfo info = null;
        block7: while (true) {
            OSGiManifestEntryParser.EventType type = parser.next();
            switch (type) {
                case BEGIN: {
                    break;
                }
                case PATH: {
                    info = new PackageInfo(parser.getText());
                    break;
                }
                case PARAMETER: {
                    String text = parser.getText();
                    if (!text.startsWith(VERSION) || this.parseVersion(text, info, context)) continue block7;
                    return null;
                }
                case END_CLAUSE: {
                    JavaExport export = new JavaExport(info);
                    exports.add(export);
                    break;
                }
                case END: {
                    return exports;
                }
            }
        }
    }

    private boolean parseVersion(String text, PackageInfo info, IntrospectionContext context) {
        String val = text.substring(VERSION.length());
        if (val.startsWith("\"[")) {
            info.setMinInclusive(true);
            val = val.substring(2);
        } else if (val.startsWith("\"(")) {
            info.setMinInclusive(false);
            val = val.substring(2);
        } else if (val.startsWith("\"")) {
            val = val.substring(1);
        }
        if (val.endsWith("]\"")) {
            info.setMaxInclusive(true);
            val = val.substring(0, val.length() - 2);
        } else if (val.endsWith(")\"")) {
            info.setMaxInclusive(false);
            val = val.substring(0, val.length() - 2);
        } else if (val.endsWith("\"")) {
            val = val.substring(0, val.length() - 1);
        }
        String[] versions = val.split(",");
        try {
            Version packageVersion = new Version(versions[0]);
            info.setMinVersion(packageVersion);
            if (versions.length == 2) {
                packageVersion = new Version(versions[1]);
                info.setMaxVersion(packageVersion);
            }
        }
        catch (IllegalArgumentException e) {
            InvalidOSGiManifest failure = new InvalidOSGiManifest("Invalid version " + versions[0] + " in: " + text, e);
            context.addError((ValidationFailure)failure);
            return false;
        }
        return true;
    }
}

