/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.manifest;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.contribution.manifest.ExtendsDeclaration;
import org.fabric3.contribution.manifest.MissingManifestAttribute;
import org.fabric3.contribution.manifest.ProvidesDeclaration;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidQNamePrefix;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.introspection.xml.UnrecognizedElement;
import org.fabric3.spi.model.os.Library;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ContributionElementLoader
implements TypeLoader<ContributionManifest> {
    private static final QName CONTRIBUTION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "contribution");
    private static final QName DEPLOYABLE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "deployable");
    private static final QName SCAN = new QName("urn:fabric3.org", "scan");
    private static final QName PROVIDES_CAPABILITY = new QName("urn:fabric3.org", "provides.capability");
    private static final QName REQUIRES_CAPABILITY = new QName("urn:fabric3.org", "requires.capability");
    private final LoaderRegistry registry;

    public ContributionElementLoader(@Reference LoaderRegistry registry) {
        this.registry = registry;
    }

    @Init
    public void start() {
        this.registry.registerLoader(CONTRIBUTION, (TypeLoader)this);
    }

    @Destroy
    public void stop() {
        this.registry.unregisterLoader(CONTRIBUTION);
    }

    public ContributionManifest load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        ContributionManifest manifest = new ContributionManifest();
        QName element = reader.getName();
        if (!CONTRIBUTION.equals(element)) {
            throw new AssertionError((Object)("Loader not positioned on the <contribution> element: " + element));
        }
        this.validateContributionAttributes(reader, context);
        boolean extension = Boolean.valueOf(reader.getAttributeValue("urn:fabric3.org", "extension"));
        manifest.setExtension(extension);
        String bootLevelStr = reader.getAttributeValue("urn:fabric3.org", "boot.level");
        if (bootLevelStr != null) {
            try {
                manifest.setBootLevel(Integer.parseInt(bootLevelStr));
            }
            catch (NumberFormatException e) {
                context.addError((ValidationFailure)new InvalidValue("Invalid boot level: " + bootLevelStr, reader.getLocation(), (Throwable)e, new ModelObject[0]));
            }
        }
        String contextPath = reader.getAttributeValue("urn:fabric3.org", "context");
        manifest.setContext(contextPath);
        String description = reader.getAttributeValue("urn:fabric3.org", "description");
        manifest.setDescription(description);
        while (true) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    Object declaration;
                    MissingManifestAttribute failure;
                    element = reader.getName();
                    Location location = reader.getLocation();
                    if (DEPLOYABLE.equals(element)) {
                        QName qName;
                        this.validateDeployableAttributes(reader, context);
                        String name = reader.getAttributeValue(null, "composite");
                        if (name == null) {
                            failure = new MissingManifestAttribute("Composite attribute must be specified", location);
                            context.addError((ValidationFailure)failure);
                            return null;
                        }
                        int index = name.indexOf(58);
                        if (index != -1) {
                            String prefix = name.substring(0, index);
                            String localPart = name.substring(index + 1);
                            String ns = reader.getNamespaceContext().getNamespaceURI(prefix);
                            if (ns == null) {
                                URI uri = context.getContributionUri();
                                context.addError((ValidationFailure)new InvalidQNamePrefix("The prefix " + prefix + " specified in the contribution manifest file for " + uri + " is invalid", location));
                                return null;
                            }
                            qName = new QName(ns, localPart, prefix);
                        } else {
                            qName = new QName(null, name);
                        }
                        List<RuntimeMode> runtimeModes = this.parseRuntimeModes(reader, context);
                        List<String> environments = this.parseEnvironments(reader);
                        Deployable deployable = new Deployable(qName, runtimeModes, environments);
                        manifest.addDeployable(deployable);
                        break;
                    }
                    if (REQUIRES_CAPABILITY.equals(element)) {
                        this.parseRequiredCapabilities(manifest, reader, context);
                        break;
                    }
                    if (PROVIDES_CAPABILITY.equals(element)) {
                        this.parseProvidedCapabilities(manifest, reader, context);
                        break;
                    }
                    if (SCAN.equals(element)) {
                        this.validateScanAttributes(reader, context);
                        String excludeAttr = reader.getAttributeValue(null, "exclude");
                        if (excludeAttr == null) {
                            MissingAttribute error = new MissingAttribute("The exclude attribute must be set on the scan element", location, new ModelObject[0]);
                            context.addError((ValidationFailure)error);
                            break;
                        }
                        String[] excludes = excludeAttr.split(",");
                        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                        for (String exclude : excludes) {
                            patterns.add(Pattern.compile(exclude));
                        }
                        manifest.setScanExcludes(patterns);
                        break;
                    }
                    Object object = this.registry.load(reader, Object.class, context);
                    if (object instanceof Export) {
                        manifest.addExport((Export)object);
                        break;
                    }
                    if (object instanceof Import) {
                        manifest.addImport((Import)object);
                        break;
                    }
                    if (object instanceof ExtendsDeclaration) {
                        declaration = (ExtendsDeclaration)object;
                        manifest.addExtend(((ExtendsDeclaration)declaration).getName());
                        break;
                    }
                    if (object instanceof ProvidesDeclaration) {
                        declaration = (ProvidesDeclaration)object;
                        manifest.addExtensionPoint(((ProvidesDeclaration)declaration).getName());
                        break;
                    }
                    if (object instanceof Library) {
                        Library library = (Library)object;
                        manifest.addLibrary(library);
                        break;
                    }
                    if (object == null) break;
                    failure = new UnrecognizedElement(reader, location, new ModelObject[0]);
                    context.addError((ValidationFailure)failure);
                    return null;
                }
                case 2: {
                    if (!CONTRIBUTION.equals(reader.getName())) break;
                    return manifest;
                }
            }
        }
    }

    private void parseProvidedCapabilities(ContributionManifest manifest, XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute error = new MissingAttribute("Capability name must be specified", location, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            return;
        }
        Capability capability = new Capability(name);
        manifest.addProvidedCapability(capability);
    }

    private void parseRequiredCapabilities(ContributionManifest manifest, XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        String name = reader.getAttributeValue(null, "name");
        if (name == null) {
            MissingAttribute error = new MissingAttribute("Capability name must be specified", location, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            return;
        }
        boolean loaded = Boolean.valueOf(reader.getAttributeValue(null, "loaded"));
        Capability capability = new Capability(name, loaded);
        manifest.addRequiredCapability(capability);
    }

    private List<RuntimeMode> parseRuntimeModes(XMLStreamReader reader, IntrospectionContext context) {
        List<Object> runtimeModes;
        String modeAttr = reader.getAttributeValue(null, "modes");
        if (modeAttr == null) {
            runtimeModes = Deployable.DEFAULT_MODES;
        } else {
            String[] modes = modeAttr.trim().split(" ");
            runtimeModes = new ArrayList<RuntimeMode>();
            for (String mode : modes) {
                if ("vm".equals(mode)) {
                    runtimeModes.add(RuntimeMode.VM);
                    continue;
                }
                if ("node".equals(mode)) {
                    runtimeModes.add(RuntimeMode.NODE);
                    continue;
                }
                runtimeModes = Deployable.DEFAULT_MODES;
                Location location = reader.getLocation();
                InvalidValue error = new InvalidValue("Invalid mode attribute: " + modeAttr, location, new ModelObject[0]);
                context.addError((ValidationFailure)error);
                break;
            }
        }
        return runtimeModes;
    }

    private List<String> parseEnvironments(XMLStreamReader reader) {
        String modeAttr = reader.getAttributeValue(null, "environments");
        if (modeAttr == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(modeAttr.trim().split(" "));
    }

    private void validateContributionAttributes(XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("extension".equals(name) || "description".equals(name) || "context".equals(name) || "capabilities".equals(name) || "required-capabilities".equals(name) || "boot.level".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, location, new ModelObject[0]));
        }
    }

    private void validateDeployableAttributes(XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("composite".equals(name) || "modes".equals(name) || "environments".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, location, new ModelObject[0]));
        }
    }

    private void validateScanAttributes(XMLStreamReader reader, IntrospectionContext context) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("exclude".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, location, new ModelObject[0]));
        }
    }
}

