/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.listener;

import java.util.ArrayList;
import java.util.List;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.contribution.manifest.JavaExport;
import org.fabric3.spi.contribution.manifest.JavaImport;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class APIImportListener
implements ContributionServiceListener {
    public static final String BINDING_PACKAGE = "org.fabric3.api.binding.";
    public static final String IMPLEMENTATION_PACKAGE = "org.fabric3.api.implementation.";
    private List<JavaImport> imports = new ArrayList<JavaImport>();

    public void onStore(Contribution contribution) {
    }

    public void onProcessManifest(Contribution contribution) {
        ContributionManifest manifest = contribution.getManifest();
        if (manifest.isExtension()) {
            return;
        }
        this.imports.forEach(arg_0 -> ((ContributionManifest)manifest).addImport(arg_0));
    }

    public void onInstall(Contribution contribution) {
        ContributionManifest manifest = contribution.getManifest();
        if (!manifest.isExtension()) {
            return;
        }
        manifest.getExports().stream().filter(export -> export instanceof JavaExport).forEach(export -> {
            JavaExport javaExport = (JavaExport)export;
            String name = javaExport.getPackageInfo().getName();
            if (name.startsWith(BINDING_PACKAGE) || name.startsWith(IMPLEMENTATION_PACKAGE)) {
                JavaImport imprt = new JavaImport(javaExport.getPackageInfo());
                this.imports.add(imprt);
            }
        });
    }

    public void onUpdate(Contribution contribution) {
    }

    public void onUninstall(Contribution contribution) {
        ContributionManifest manifest = contribution.getManifest();
        if (!manifest.isExtension()) {
            return;
        }
        manifest.getExports().stream().filter(export -> export instanceof JavaExport).forEach(export -> {
            JavaExport javaExport = (JavaExport)export;
            String name = javaExport.getPackageInfo().getName();
            if (name.startsWith(BINDING_PACKAGE) || name.startsWith(IMPLEMENTATION_PACKAGE)) {
                JavaImport imprt = new JavaImport(javaExport.getPackageInfo());
                this.imports.remove(imprt);
            }
        });
    }

    public void onRemove(Contribution contribution) {
    }
}

