/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.archive;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.JavaArtifactIntrospector;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.archive.ArchiveContributionHandler;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.Loader;
import org.oasisopen.sca.annotation.Reference;

public class ExplodedArchiveContributionHandler
implements ArchiveContributionHandler {
    private static final int CLASS_SUFFIX = 6;
    private Loader loader;
    private List<JavaArtifactIntrospector> artifactIntrospectors = Collections.emptyList();
    private final ContentTypeResolver contentTypeResolver;

    public ExplodedArchiveContributionHandler(@Reference Loader loader, @Reference ContentTypeResolver contentTypeResolver) {
        this.loader = loader;
        this.contentTypeResolver = contentTypeResolver;
    }

    @Reference
    public void setArtifactIntrospectors(List<JavaArtifactIntrospector> introspectors) {
        this.artifactIntrospectors = introspectors;
    }

    public boolean canProcess(Contribution contribution) {
        URL location = contribution.getLocation();
        if (location == null || !"file".equals(location.getProtocol())) {
            return false;
        }
        File file = new File(location.getFile());
        String contentType = contribution.getContentType();
        return file.isDirectory() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip") || "text/vnd.fabric3.exploded".equals(contentType));
    }

    public void processManifest(Contribution contribution, IntrospectionContext context) {
        block5: {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                URI uri = contribution.getUri();
                DefaultIntrospectionContext childContext = new DefaultIntrospectionContext(uri, cl);
                Optional<URL> manifestUrl = this.getManifestUrl(contribution);
                if (manifestUrl.isPresent()) {
                    UrlSource source = new UrlSource(manifestUrl.get());
                    ContributionManifest manifest = (ContributionManifest)this.loader.load((Source)source, ContributionManifest.class, (IntrospectionContext)childContext);
                    if (childContext.hasErrors()) {
                        context.addErrors(childContext.getErrors());
                    }
                    if (childContext.hasWarnings()) {
                        context.addWarnings(childContext.getWarnings());
                    }
                    contribution.setManifest(manifest);
                }
            }
            catch (Fabric3Exception e) {
                if (e.getCause() instanceof FileNotFoundException) break block5;
                throw e;
            }
        }
    }

    public void iterateArtifacts(Contribution contribution, Consumer<Resource> callback, IntrospectionContext context) {
        File root = FileHelper.toFile((URL)contribution.getLocation());
        this.iterateArtifactsRecursive(root, root, contribution, callback, context);
        for (URL url : contribution.getAdditionalLocations()) {
            root = FileHelper.toFile((URL)url);
            this.iterateArtifactsRecursive(root, root, contribution, callback, context);
        }
    }

    protected void iterateArtifactsRecursive(File dir, File root, Contribution contribution, Consumer<Resource> callback, IntrospectionContext context) {
        File[] files = dir.listFiles();
        ContributionManifest manifest = contribution.getManifest();
        for (File file : files) {
            if (file.isDirectory()) {
                this.iterateArtifactsRecursive(file, root, contribution, callback, context);
                continue;
            }
            try {
                Resource resource;
                String name = file.getName();
                if (name.equals("sca-contribution.xml") || this.exclude(file, root, manifest)) continue;
                boolean isClass = file.getName().endsWith(".class");
                if (isClass) {
                    String relativeName = this.getRelativeName(file, root).replace(File.separator, ".");
                    name = relativeName.substring(0, relativeName.length() - 6);
                    try {
                        JavaArtifactIntrospector introspector;
                        Class<?> clazz = context.getClassLoader().loadClass(name);
                        URL entryUrl = file.toURI().toURL();
                        resource = null;
                        Iterator<JavaArtifactIntrospector> iterator = this.artifactIntrospectors.iterator();
                        while (iterator.hasNext() && (resource = (introspector = iterator.next()).inspect(clazz, entryUrl, contribution, context)) == null) {
                        }
                        if (resource == null) continue;
                        contribution.addResource(resource);
                        callback.accept(resource);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError clazz) {}
                    continue;
                }
                String contentType = this.contentTypeResolver.getContentType(name);
                if (contentType == null) continue;
                URL entryUrl = file.toURI().toURL();
                UrlSource source = new UrlSource(entryUrl);
                resource = new Resource(contribution, (Source)source, contentType);
                contribution.addResource(resource);
                callback.accept(resource);
            }
            catch (MalformedURLException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
    }

    private Optional<URL> getManifestUrl(Contribution contribution) {
        String sourceUrl = contribution.getLocation().toString();
        Optional<URL> manifestUrl = this.searchManifestUrl(sourceUrl);
        if (manifestUrl.isPresent()) {
            return manifestUrl;
        }
        for (URL url : contribution.getAdditionalLocations()) {
            manifestUrl = this.searchManifestUrl(url.toString());
            if (!manifestUrl.isPresent()) continue;
            return manifestUrl;
        }
        return Optional.empty();
    }

    private Optional<URL> searchManifestUrl(String sourceUrl) {
        Optional<URL> manifestUrl = this.getManifestUrl(sourceUrl + "/META-INF/sca-contribution.xml");
        if (manifestUrl.isPresent()) {
            return manifestUrl;
        }
        manifestUrl = this.getManifestUrl(sourceUrl + "/WEB-INF/sca-contribution.xml");
        if (manifestUrl.isPresent()) {
            return manifestUrl;
        }
        return Optional.empty();
    }

    private Optional<URL> getManifestUrl(String url) {
        try {
            URL manifestUrl = new URL(url);
            File file = new File(manifestUrl.getPath());
            return file.exists() ? Optional.of(manifestUrl) : Optional.empty();
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
    }

    private boolean exclude(File file, File root, ContributionManifest manifest) {
        String relativeName = this.getRelativeName(file, root);
        for (Pattern pattern : manifest.getScanExcludes()) {
            if (!pattern.matcher(relativeName).matches()) continue;
            return true;
        }
        return false;
    }

    private String getRelativeName(File file, File root) {
        return file.toURI().toString().substring(root.toURI().toString().length());
    }
}

