/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.contribution.DependencyResolver;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.ContributionWire;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.util.graph.Cycle;
import org.fabric3.util.graph.CycleDetector;
import org.fabric3.util.graph.CycleDetectorImpl;
import org.fabric3.util.graph.DirectedGraph;
import org.fabric3.util.graph.DirectedGraphImpl;
import org.fabric3.util.graph.Edge;
import org.fabric3.util.graph.EdgeImpl;
import org.fabric3.util.graph.GraphException;
import org.fabric3.util.graph.TopologicalSorter;
import org.fabric3.util.graph.TopologicalSorterImpl;
import org.fabric3.util.graph.Vertex;
import org.fabric3.util.graph.VertexImpl;
import org.oasisopen.sca.annotation.Reference;

public class DependencyResolverImpl
implements DependencyResolver {
    private CycleDetector<Contribution> detector;
    private TopologicalSorter<Contribution> sorter;
    private MetaDataStore store;

    public DependencyResolverImpl(@Reference MetaDataStore store) {
        this.store = store;
        this.detector = new CycleDetectorImpl();
        this.sorter = new TopologicalSorterImpl();
    }

    @Override
    public List<Contribution> resolve(List<Contribution> contributions) {
        DirectedGraphImpl dag = new DirectedGraphImpl();
        for (Contribution contribution : contributions) {
            dag.add((Vertex)new VertexImpl((Object)contribution));
        }
        for (Vertex source : dag.getVertices()) {
            this.resolveImports((Vertex<Contribution>)source, (DirectedGraph<Contribution>)dag);
            this.resolveCapabilities((Vertex<Contribution>)source, (DirectedGraph<Contribution>)dag);
        }
        return this.sort((DirectedGraph<Contribution>)dag);
    }

    @Override
    public List<Contribution> orderForUninstall(List<Contribution> contributions) {
        DirectedGraphImpl dag = new DirectedGraphImpl();
        for (Contribution contribution : contributions) {
            dag.add((Vertex)new VertexImpl((Object)contribution));
        }
        for (Vertex source : dag.getVertices()) {
            Contribution contribution = (Contribution)source.getEntity();
            URI uri = contribution.getUri();
            block4: for (ContributionWire wire : contribution.getWires()) {
                for (Contribution entry : contributions) {
                    if (!entry.getUri().equals(wire.getExportContributionUri())) continue;
                    Import imprt = wire.getImport();
                    List<Vertex<Contribution>> sinks = this.resolveImport(imprt, uri, (DirectedGraph<Contribution>)dag);
                    if (sinks.isEmpty()) {
                        throw new AssertionError((Object)("Unable to resolve import " + imprt + " in " + uri));
                    }
                    for (Vertex<Contribution> sink : sinks) {
                        EdgeImpl edge = new EdgeImpl(source, sink);
                        dag.add((Edge)edge);
                    }
                    continue block4;
                }
            }
        }
        List cycles = this.detector.findCycles((DirectedGraph)dag);
        if (!cycles.isEmpty()) {
            throw new AssertionError((Object)"Cycles detected");
        }
        try {
            List vertices = this.sorter.sort((DirectedGraph)dag);
            ArrayList<Contribution> ordered = new ArrayList<Contribution>(vertices.size());
            ordered.addAll(vertices.stream().map(Vertex::getEntity).collect(Collectors.toList()));
            return ordered;
        }
        catch (GraphException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public List<Contribution> orderContributionAndDependents(URI uri) {
        Contribution contribution = this.store.find(uri);
        ArrayList<Contribution> dependents = new ArrayList<Contribution>();
        Set contributions = this.store.getContributions();
        this.addDependents(contribution, dependents, contributions);
        return this.orderForUninstall(dependents);
    }

    private void addDependents(Contribution current, List<Contribution> dependents, Set<Contribution> contributions) {
        dependents.add(current);
        URI currentUri = current.getUri();
        contributions.forEach(c -> {
            if (dependents.contains(c)) {
                return;
            }
            c.getWires().stream().filter(wire -> {
                URI exportedUri = wire.getExportContributionUri();
                return currentUri.equals(exportedUri);
            }).forEach(wire -> this.addDependents((Contribution)c, dependents, contributions));
        });
    }

    private void resolveImports(Vertex<Contribution> source, DirectedGraph<Contribution> dag) {
        Contribution contribution = (Contribution)source.getEntity();
        ContributionManifest manifest = contribution.getManifest();
        Iterator<Import> iterator = manifest.getImports().iterator();
        while (iterator.hasNext()) {
            Import imprt = (Import)iterator.next();
            boolean hasExport = this.hasMatchingExport(contribution, imprt);
            if (hasExport) {
                this.resolveOverlappingImport(imprt, iterator, source, dag);
                continue;
            }
            this.resolveExternalImport(imprt, source, dag);
        }
    }

    private void resolveExternalImport(Import imprt, Vertex<Contribution> source, DirectedGraph<Contribution> dag) {
        Contribution contribution = (Contribution)source.getEntity();
        URI uri = contribution.getUri();
        List<Vertex<Contribution>> sinks = this.resolveImport(imprt, uri, dag);
        if (sinks.isEmpty()) {
            List resolvedContributions = this.store.resolve(uri, imprt);
            this.checkInstalled(contribution, resolvedContributions);
            if (resolvedContributions.isEmpty() && imprt.isRequired()) {
                throw new Fabric3Exception("Unable to resolve import " + imprt + " in " + uri);
            }
        } else {
            for (Vertex<Contribution> sink : sinks) {
                EdgeImpl edge = new EdgeImpl(source, sink);
                dag.add((Edge)edge);
            }
        }
    }

    private void resolveOverlappingImport(Import imprt, Iterator<Import> iterator, Vertex<Contribution> source, DirectedGraph<Contribution> dag) {
        Contribution contribution = (Contribution)source.getEntity();
        ContributionManifest manifest = contribution.getManifest();
        URI uri = contribution.getUri();
        List<Vertex<Contribution>> sinks = this.resolveImport(imprt, uri, dag);
        if (sinks.isEmpty()) {
            List resolvedContributions = this.store.resolve(uri, imprt);
            this.checkInstalled(contribution, resolvedContributions);
            if (resolvedContributions.isEmpty()) {
                iterator.remove();
            } else {
                this.dropExport(imprt, manifest);
            }
        } else {
            for (Vertex<Contribution> sink : sinks) {
                EdgeImpl edge = new EdgeImpl(source, sink);
                dag.add((Edge)edge);
            }
            this.dropExport(imprt, manifest);
        }
    }

    private void resolveCapabilities(Vertex<Contribution> source, DirectedGraph<Contribution> dag) {
        Contribution contribution = (Contribution)source.getEntity();
        URI uri = contribution.getUri();
        for (Capability capability : contribution.getManifest().getRequiredCapabilities()) {
            List<Vertex<Contribution>> sinks = this.findCapabilityVertices(capability, uri, dag);
            if (sinks.isEmpty()) {
                Set resolvedContributions = this.store.resolveCapability(capability.getName());
                for (Contribution resolved : resolvedContributions) {
                    if (resolved == null || ContributionState.INSTALLED == resolved.getState() || ContributionState.DEPLOYED == resolved.getState()) continue;
                    throw new Fabric3Exception("Contribution " + contribution.getUri() + " requires a capability provided by " + resolved.getUri() + " which is not installed");
                }
                if (!resolvedContributions.isEmpty()) continue;
                throw new Fabric3Exception("Unable to resolve capability " + capability + " required by " + uri);
            }
            for (Vertex<Contribution> sink : sinks) {
                EdgeImpl edge = new EdgeImpl(source, sink);
                dag.add((Edge)edge);
            }
        }
    }

    private List<Vertex<Contribution>> resolveImport(Import imprt, URI contributionUri, DirectedGraph<Contribution> dag) {
        Export export;
        Vertex vertex;
        ArrayList<Vertex<Contribution>> vertices = new ArrayList<Vertex<Contribution>>();
        LinkedHashMap<Vertex, Export> candidates = new LinkedHashMap<Vertex, Export>();
        if (!imprt.getResolved().isEmpty()) {
            block0: for (Map.Entry entry : imprt.getResolved().entrySet()) {
                for (Vertex vertex2 : dag.getVertices()) {
                    if (!((Contribution)vertex2.getEntity()).getUri().equals(entry.getKey())) continue;
                    vertices.add((Vertex<Contribution>)vertex2);
                    continue block0;
                }
            }
            return vertices;
        }
        block2: for (Vertex vertex2 : dag.getVertices()) {
            Contribution contribution = (Contribution)vertex2.getEntity();
            ContributionManifest manifest = contribution.getManifest();
            URI location = imprt.getLocation();
            for (Export export2 : manifest.getExports()) {
                URI exportUri = contribution.getUri();
                if (!export2.match(imprt) || contributionUri.equals(contribution.getUri())) continue;
                if (location != null) {
                    if (!location.equals(exportUri)) continue;
                    vertices.add((Vertex<Contribution>)vertex2);
                    imprt.addResolved(exportUri, export2);
                    export2.resolve();
                    this.dropImport(export2, manifest);
                    return vertices;
                }
                if (!imprt.isMultiplicity() && export2.isResolved()) {
                    vertices.add((Vertex<Contribution>)vertex2);
                    imprt.addResolved(exportUri, export2);
                    return vertices;
                }
                candidates.put(vertex2, export2);
                continue block2;
            }
        }
        for (Map.Entry entry : candidates.entrySet()) {
            vertex = (Vertex)entry.getKey();
            export = (Export)entry.getValue();
            if (!export.isResolved()) continue;
            vertices.add((Vertex<Contribution>)vertex);
            imprt.addResolved(((Contribution)vertex.getEntity()).getUri(), export);
            if (imprt.isMultiplicity()) continue;
            return vertices;
        }
        if (vertices.isEmpty() && !candidates.isEmpty()) {
            for (Map.Entry entry : candidates.entrySet()) {
                vertex = (Vertex)entry.getKey();
                export = (Export)entry.getValue();
                vertices.add((Vertex<Contribution>)vertex);
                imprt.addResolved(((Contribution)vertex.getEntity()).getUri(), export);
                export.resolve();
                this.dropImport(export, ((Contribution)vertex.getEntity()).getManifest());
                if (imprt.isMultiplicity()) continue;
                return vertices;
            }
        }
        return vertices;
    }

    private boolean hasMatchingExport(Contribution contribution, Import imprt) {
        for (Export export : contribution.getManifest().getExports()) {
            if (!export.match(imprt)) continue;
            return true;
        }
        return false;
    }

    private List<Contribution> sort(DirectedGraph<Contribution> dag) {
        List cycles = this.detector.findCycles(dag);
        if (!cycles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Cycle cycle : cycles) {
                for (Vertex vertex : cycle.getOriginPath()) {
                    builder.append(((Contribution)vertex.getEntity()).getUri()).append("\n");
                }
            }
            throw new Fabric3Exception("Cyclic dependencies found:\n" + builder);
        }
        try {
            List vertices = this.sorter.reverseSort(dag);
            ArrayList<Contribution> ordered = new ArrayList<Contribution>(vertices.size());
            ordered.addAll(vertices.stream().map(Vertex::getEntity).collect(Collectors.toList()));
            return ordered;
        }
        catch (GraphException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    private List<Vertex<Contribution>> findCapabilityVertices(Capability capability, URI contributionUri, DirectedGraph<Contribution> dag) {
        ArrayList<Vertex<Contribution>> vertices = new ArrayList<Vertex<Contribution>>();
        for (Vertex vertex : dag.getVertices()) {
            Contribution contribution = (Contribution)vertex.getEntity();
            if (!contribution.getManifest().getProvidedCapabilities().contains(capability) || contributionUri.equals(contribution.getUri())) continue;
            vertices.add((Vertex<Contribution>)vertex);
            break;
        }
        return vertices;
    }

    private void dropExport(Import imprt, ContributionManifest manifest) {
        if (imprt.isMultiplicity()) {
            return;
        }
        Iterator iterator = manifest.getExports().iterator();
        while (iterator.hasNext()) {
            Export export = (Export)iterator.next();
            if (!export.match(imprt)) continue;
            iterator.remove();
            break;
        }
    }

    private void dropImport(Export export, ContributionManifest manifest) {
        Iterator iterator = manifest.getImports().iterator();
        while (iterator.hasNext()) {
            Import imprt = (Import)iterator.next();
            if (imprt.isMultiplicity()) {
                return;
            }
            if (!export.match(imprt)) continue;
            iterator.remove();
            break;
        }
    }

    private void checkInstalled(Contribution contribution, List<Contribution> resolvedContributions) {
        for (Contribution resolved : resolvedContributions) {
            if (resolved == null || ContributionState.INSTALLED == resolved.getState() || ContributionState.DEPLOYED == resolved.getState()) continue;
            throw new Fabric3Exception("Contribution " + contribution.getUri() + " imports " + resolved.getUri() + " which is not installed");
        }
    }
}

