/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.ArtifactValidationFailure;
import org.fabric3.api.host.contribution.ContributionOrder;
import org.fabric3.api.host.contribution.ContributionService;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.Deployable;
import org.fabric3.api.host.contribution.ValidationException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.failure.ValidationUtils;
import org.fabric3.api.host.stream.Source;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Composite;
import org.fabric3.contribution.ContributionLoader;
import org.fabric3.contribution.ContributionServiceMonitor;
import org.fabric3.contribution.DependencyResolver;
import org.fabric3.contribution.InvalidDeployable;
import org.fabric3.spi.contribution.Capability;
import org.fabric3.spi.contribution.ContentTypeResolver;
import org.fabric3.spi.contribution.Contribution;
import org.fabric3.spi.contribution.ContributionManifest;
import org.fabric3.spi.contribution.ContributionServiceListener;
import org.fabric3.spi.contribution.ContributionState;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.manifest.QNameSymbol;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ContributionServiceImpl
implements ContributionService {
    private ProcessorRegistry processorRegistry;
    private MetaDataStore metaDataStore;
    private ContributionLoader contributionLoader;
    private ContentTypeResolver contentTypeResolver;
    private DependencyResolver dependencyResolver;
    private ContributionServiceMonitor monitor;
    private List<ContributionServiceListener> listeners;

    public ContributionServiceImpl(@Reference ProcessorRegistry processorRegistry, @Reference MetaDataStore metaDataStore, @Reference ContributionLoader contributionLoader, @Reference ContentTypeResolver contentTypeResolver, @Reference DependencyResolver dependencyResolver, @Monitor ContributionServiceMonitor monitor) {
        this.processorRegistry = processorRegistry;
        this.metaDataStore = metaDataStore;
        this.contributionLoader = contributionLoader;
        this.contentTypeResolver = contentTypeResolver;
        this.dependencyResolver = dependencyResolver;
        this.monitor = monitor;
        this.listeners = new ArrayList<ContributionServiceListener>();
    }

    @Reference(required=false)
    public void setListeners(List<ContributionServiceListener> listeners) {
        this.listeners = listeners;
    }

    public Set<URI> getContributions() {
        Set contributions = this.metaDataStore.getContributions();
        HashSet<URI> uris = new HashSet<URI>(contributions.size());
        uris.addAll(contributions.stream().map(Contribution::getUri).collect(Collectors.toList()));
        return uris;
    }

    public boolean exists(URI uri) {
        return this.metaDataStore.find(uri) != null;
    }

    public List<URI> getContributionAndDependents(URI uri) {
        List<Contribution> contributions = this.dependencyResolver.orderContributionAndDependents(uri);
        return contributions.stream().map(Contribution::getUri).collect(Collectors.toList());
    }

    public List<Deployable> getDeployables(URI uri) {
        Contribution contribution = this.find(uri);
        ArrayList<Deployable> list = new ArrayList<Deployable>();
        if (contribution.getManifest() != null) {
            list.addAll(contribution.getManifest().getDeployables().stream().collect(Collectors.toList()));
        }
        return list;
    }

    public URI store(ContributionSource contributionSource) {
        Contribution contribution = this.create(contributionSource);
        this.metaDataStore.store(contribution);
        for (ContributionServiceListener listener : this.listeners) {
            listener.onStore(contribution);
        }
        return contribution.getUri();
    }

    public List<URI> store(List<ContributionSource> contributionSources) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (ContributionSource contributionSource : contributionSources) {
            URI uri = this.store(contributionSource);
            uris.add(uri);
        }
        return uris;
    }

    public void install(URI uri) {
        this.install(Collections.singletonList(uri));
    }

    public List<URI> install(List<URI> uris) {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>(uris.size());
        for (URI uri : uris) {
            Contribution contribution = this.find(uri);
            contributions.add(contribution);
        }
        return this.installInOrder(contributions);
    }

    public void uninstall(URI uri) {
        Contribution contribution = this.find(uri);
        this.uninstall(contribution);
    }

    public void uninstall(List<URI> uris) {
        List<Contribution> contributions = new ArrayList<Contribution>(uris.size());
        for (URI uri : uris) {
            Contribution contribution = this.find(uri);
            contributions.add(contribution);
        }
        contributions = this.dependencyResolver.orderForUninstall(contributions);
        contributions.forEach(this::uninstall);
    }

    public void remove(URI uri) {
        Contribution contribution = this.find(uri);
        if (contribution.getState() != ContributionState.STORED) {
            throw new Fabric3Exception("Contribution must first be uninstalled: " + uri);
        }
        this.metaDataStore.remove(uri);
        for (ContributionServiceListener listener : this.listeners) {
            listener.onRemove(contribution);
        }
    }

    public void remove(List<URI> uris) {
        uris.forEach(this::remove);
    }

    public ContributionOrder processManifests(List<ContributionSource> contributionSources) {
        ArrayList<Contribution> contributions = new ArrayList<Contribution>();
        for (ContributionSource contributionSource : contributionSources) {
            Contribution contribution = this.create(contributionSource);
            this.metaDataStore.store(contribution);
            for (ContributionServiceListener listener : this.listeners) {
                listener.onStore(contribution);
            }
            contributions.add(contribution);
        }
        return this.introspectManifests(contributions);
    }

    public void processContents(URI uri) {
        Contribution contribution = this.find(uri);
        try {
            ClassLoader loader = this.contributionLoader.load(contribution);
            this.processContents(contribution, loader);
            contribution.install();
            for (ContributionServiceListener listener : this.listeners) {
                listener.onInstall(contribution);
            }
        }
        catch (Fabric3Exception e) {
            try {
                this.revertInstall(Collections.singletonList(contribution));
            }
            catch (RuntimeException ex) {
                this.monitor.error("Error reverting deployment", ex);
            }
            throw e;
        }
        String description = contribution.getManifest().getDescription();
        if (description != null) {
            this.monitor.installed(description);
        }
    }

    private ContributionOrder introspectManifests(List<Contribution> contributions) {
        ContributionOrder order = new ContributionOrder();
        for (Contribution contribution : contributions) {
            if (ContributionState.STORED == contribution.getState()) continue;
            throw new Fabric3Exception("Contribution is already installed: " + contribution.getUri());
        }
        contributions.forEach(this::processManifest);
        contributions = this.dependencyResolver.resolve(contributions);
        ArrayList<Contribution> bootContributions = new ArrayList<Contribution>();
        for (Contribution contribution : contributions) {
            boolean requiresLoad = false;
            ContributionManifest manifest = contribution.getManifest();
            for (Capability capability : manifest.getRequiredCapabilities()) {
                if (!capability.requiresLoad()) continue;
                requiresLoad = true;
                break;
            }
            if (requiresLoad) {
                order.addIsolatedContribution(contribution.getUri());
                continue;
            }
            if (manifest.getBootLevel() > -1) {
                bootContributions.add(contribution);
                continue;
            }
            order.addBaseContribution(contribution.getUri());
        }
        Collections.sort(bootContributions, (c1, c2) -> c1.getManifest().getBootLevel() - c2.getManifest().getBootLevel());
        for (Contribution contribution : bootContributions) {
            order.addBootstrapContribution(contribution.getUri());
        }
        return order;
    }

    private Contribution find(URI uri) {
        Contribution contribution = this.metaDataStore.find(uri);
        if (contribution == null) {
            throw new Fabric3Exception("Contribution not found: " + uri);
        }
        return contribution;
    }

    private List<URI> installInOrder(List<Contribution> contributions) {
        for (Contribution contribution : contributions) {
            if (ContributionState.STORED == contribution.getState()) continue;
            throw new Fabric3Exception("Contribution is already installed: " + contribution.getUri());
        }
        contributions.forEach(this::processManifest);
        contributions = this.dependencyResolver.resolve(contributions);
        try {
            for (Contribution contribution : contributions) {
                ClassLoader loader = this.contributionLoader.load(contribution);
                this.processContents(contribution, loader);
                URI contributionUri = contribution.getUri();
                contribution.getResources().forEach(r -> r.getResourceElements().forEach(re -> {
                    if (re.getValue() instanceof Composite) {
                        Composite composite = (Composite)re.getValue();
                        this.setContributionUri(composite, contributionUri);
                    }
                }));
                contribution.install();
                for (ContributionServiceListener listener : this.listeners) {
                    listener.onInstall(contribution);
                }
            }
        }
        catch (Fabric3Exception e) {
            try {
                this.revertInstall(contributions);
            }
            catch (RuntimeException ex) {
                this.monitor.error("Error reverting deployment", ex);
            }
            throw e;
        }
        ArrayList<URI> uris = new ArrayList<URI>(contributions.size());
        for (Contribution contribution : contributions) {
            URI uri = contribution.getUri();
            uris.add(uri);
            String description = contribution.getManifest().getDescription();
            if (description != null) {
                this.monitor.installed(description);
                continue;
            }
            if (contribution.getManifest().isExtension()) continue;
            this.monitor.installed(uri.toString());
        }
        return uris;
    }

    private void setContributionUri(Composite composite, URI contributionUri) {
        composite.setContributionUri(contributionUri);
        composite.getComponents().values().forEach(c -> this.setContributionUri((Component)c, contributionUri));
        composite.getResources().forEach(r -> r.setContributionUri(contributionUri));
        composite.getChannels().values().forEach(c -> c.setContributionUri(contributionUri));
    }

    private void setContributionUri(Component component, URI contributionUri) {
        component.setContributionUri(contributionUri);
        if (component.getComponentType() instanceof Composite) {
            Composite composite = (Composite)component.getComponentType();
            this.setContributionUri(composite, contributionUri);
        }
    }

    private void revertInstall(List<Contribution> contributions) {
        ListIterator<Contribution> iterator = contributions.listIterator(contributions.size());
        while (iterator.hasPrevious()) {
            Contribution contribution = iterator.previous();
            try {
                if (ContributionState.INSTALLED == contribution.getState()) {
                    this.uninstall(contribution);
                }
                this.contributionLoader.unload(contribution);
                this.remove(contribution.getUri());
            }
            catch (Fabric3Exception ex) {
                this.monitor.error("Error reverting installation: " + contribution.getUri(), ex);
            }
        }
    }

    private void uninstall(Contribution contribution) {
        URI uri = contribution.getUri();
        if (contribution.getState() == ContributionState.STORED) {
            throw new Fabric3Exception("Contribution not installed: " + uri);
        }
        if (contribution.getState() == ContributionState.DEPLOYED) {
            throw new Fabric3Exception("Contribution is currently deployed: " + uri);
        }
        this.contributionLoader.unload(contribution);
        contribution.uninstall();
        for (ContributionServiceListener listener : this.listeners) {
            listener.onUninstall(contribution);
        }
        String description = contribution.getManifest().getDescription();
        if (description != null) {
            this.monitor.uninstalled(description);
        } else if (!contribution.getManifest().isExtension()) {
            this.monitor.uninstalled(uri.toString());
        }
    }

    private void processManifest(Contribution contribution) {
        DefaultIntrospectionContext context = new DefaultIntrospectionContext();
        this.processorRegistry.processManifest(contribution, (IntrospectionContext)context);
        if (context.hasErrors()) {
            URI uri = contribution.getUri();
            ArtifactValidationFailure failure = new ArtifactValidationFailure(uri, "the contribution manifest (sca-contribution.xml)");
            failure.addFailures(context.getErrors());
            ArrayList<ArtifactValidationFailure> failures = new ArrayList<ArtifactValidationFailure>();
            failures.add(failure);
            ArtifactValidationFailure warning = new ArtifactValidationFailure(uri, "the contribution manifest (sca-contribution.xml)");
            warning.addFailures(context.getWarnings());
            ArrayList<ArtifactValidationFailure> warnings = new ArrayList<ArtifactValidationFailure>();
            warnings.add(warning);
            throw new ValidationException(failures, warnings);
        }
        for (ContributionServiceListener listener : this.listeners) {
            listener.onProcessManifest(contribution);
        }
    }

    private void processContents(Contribution contribution, ClassLoader loader) {
        URI contributionUri = contribution.getUri();
        DefaultIntrospectionContext context = new DefaultIntrospectionContext(contributionUri, loader);
        this.processorRegistry.indexContribution(contribution, (IntrospectionContext)context);
        if (context.hasErrors()) {
            throw new ValidationException(context.getErrors(), context.getWarnings());
        }
        if (context.hasWarnings()) {
            this.monitor.contributionWarnings(ValidationUtils.outputWarnings((List)context.getWarnings()));
        }
        this.metaDataStore.store(contribution);
        context = new DefaultIntrospectionContext(contributionUri, loader);
        this.processorRegistry.processContribution(contribution, (IntrospectionContext)context);
        this.validateContribution(contribution, (IntrospectionContext)context);
        if (context.hasErrors()) {
            throw new ValidationException(context.getErrors(), context.getWarnings());
        }
        if (context.hasWarnings()) {
            this.monitor.contributionWarnings(ValidationUtils.outputWarnings((List)context.getWarnings()));
        }
        this.addDeployableEntries(contribution);
    }

    private void validateContribution(Contribution contribution, IntrospectionContext context) {
        for (Deployable deployable : contribution.getManifest().getDeployables()) {
            QName name = deployable.getName();
            QNameSymbol symbol = new QNameSymbol(name);
            boolean found = false;
            for (Resource resource : contribution.getResources()) {
                for (ResourceElement element : resource.getResourceElements()) {
                    if (!element.getSymbol().equals((Object)symbol)) continue;
                    found = true;
                }
            }
            if (found) continue;
            URI uri = contribution.getUri();
            InvalidDeployable failure = new InvalidDeployable("Deployable composite " + name + " not found in " + uri, name);
            context.addError((ValidationFailure)failure);
        }
    }

    private void addDeployableEntries(Contribution contribution) {
        ContributionManifest manifest = contribution.getManifest();
        for (Resource resource : contribution.getResources()) {
            resource.getResourceElements().stream().filter(element -> element.getValue() instanceof Composite).forEach(element -> {
                Composite composite = (Composite)element.getValue();
                if (composite.isDeployable()) {
                    Deployable deployable = new Deployable(composite.getName(), composite.getModes(), composite.getEnvironments());
                    if (!manifest.getDeployables().contains(deployable)) {
                        manifest.getDeployables().add(deployable);
                    }
                }
            });
        }
    }

    private Contribution create(ContributionSource contributionSource) {
        URI contributionUri = contributionSource.getUri();
        if (this.metaDataStore.find(contributionUri) != null) {
            throw new Fabric3Exception("Contribution already exists: " + contributionUri);
        }
        URL locationUrl = contributionSource.getLocation();
        Source source = contributionSource.getSource();
        String type = contributionSource.getContentType();
        if (type == null && locationUrl == null) {
            throw new Fabric3Exception("Content type could not be determined for contribution: " + contributionUri);
        }
        if (type == null) {
            type = this.contentTypeResolver.getContentType(locationUrl);
        }
        long timestamp = contributionSource.getTimestamp();
        return new Contribution(contributionUri, source, locationUrl, timestamp, type);
    }
}

