/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Method;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.introspection.java.annotation.InvalidMethod;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.oasisopen.sca.annotation.Init;

public class OASISInitProcessor
extends AbstractAnnotationProcessor<Init> {
    public OASISInitProcessor() {
        super(Init.class);
    }

    public void visitMethod(Init annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        if (!this.validate(method, context, componentType)) {
            return;
        }
        componentType.setInitMethod(method);
    }

    private boolean validate(Method method, IntrospectionContext context, InjectingComponentType componentType) {
        if (!"void".equals(method.getReturnType().getName())) {
            InvalidMethod error = new InvalidMethod("Method marked with @Init must return void: " + method, method, (ComponentType)componentType);
            context.addError((ValidationFailure)error);
            return false;
        }
        return true;
    }
}

