/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.fabric3.api.Role;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.management.OperationType;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.api.model.type.java.ManagementOperationInfo;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;

public class ManagementOperationProcessor
extends AbstractAnnotationProcessor<ManagementOperation> {
    public ManagementOperationProcessor() {
        super(ManagementOperation.class);
    }

    public void visitMethod(ManagementOperation annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        ManagementInfo info = componentType.getManagementInfo();
        if (info == null) {
            Class<?> clazz = method.getDeclaringClass();
            String name = Management.class.getSimpleName();
            context.addError((ValidationFailure)new InvalidAnnotation("Implementation is missing @" + name, (AnnotatedElement)method, (Annotation)annotation, clazz));
            return;
        }
        String description = annotation.description();
        if (description.trim().length() == 0) {
            description = null;
        }
        HashSet<Role> roles = new HashSet<Role>();
        for (String roleName : annotation.rolesAllowed()) {
            roles.add(new Role(roleName));
        }
        String path = annotation.path();
        OperationType operationType = annotation.type();
        org.fabric3.api.model.type.java.OperationType type = org.fabric3.api.model.type.java.OperationType.valueOf((String)operationType.toString());
        ManagementOperationInfo operationInfo = new ManagementOperationInfo(method, path, type, description, roles);
        info.addOperation(operationInfo);
    }
}

