/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.annotation.Consumer;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.introspection.java.annotation.InvalidConsumerMethod;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.contract.TypeIntrospector;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ConsumerProcessor
extends AbstractAnnotationProcessor<Consumer> {
    private JavaContractProcessor contractProcessor;
    private IntrospectionHelper helper;
    private List<TypeIntrospector> typeIntrospectors = Collections.emptyList();

    @Reference(required=false)
    public void setTypeIntrospectors(List<TypeIntrospector> typeIntrospectors) {
        this.typeIntrospectors = typeIntrospectors;
    }

    public ConsumerProcessor(IntrospectionHelper helper) {
        super(Consumer.class);
        this.helper = helper;
    }

    @Constructor
    public ConsumerProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(Consumer.class);
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    public void visitConstructorParameter(Consumer annotation, java.lang.reflect.Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.value());
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class<?> genericType = constructor.getParameterTypes()[index];
        Type logicalParamType = typeMapping.getActualType(genericType);
        DataType dataType = this.createDataType(genericType, logicalParamType, typeMapping);
        JavaServiceContract contract = null;
        if (this.contractProcessor != null) {
            Class baseType = this.helper.getBaseType(genericType, typeMapping);
            contract = this.contractProcessor.introspect(baseType, implClass, context, new ModelObject[]{componentType});
        }
        ConstructorInjectionSite injectionSite = new ConstructorInjectionSite(constructor, index);
        org.fabric3.api.model.type.component.Consumer consumer = new org.fabric3.api.model.type.component.Consumer(name, dataType, contract);
        if (annotation.group().length() > 0) {
            consumer.setGroup(annotation.group());
        }
        this.processSources(annotation, consumer, constructor, constructor.getDeclaringClass(), context);
        componentType.add(consumer, (InjectionSite)injectionSite, constructor);
    }

    public void visitField(Consumer annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class<?> genericType = field.getType();
        Type logicalParamType = typeMapping.getActualType(genericType);
        DataType dataType = this.createDataType(genericType, logicalParamType, typeMapping);
        String name = this.helper.getSiteName(field, annotation.value());
        JavaServiceContract contract = null;
        if (this.contractProcessor != null) {
            Class baseType = this.helper.getBaseType(genericType, typeMapping);
            contract = this.contractProcessor.introspect(baseType, implClass, context, new ModelObject[]{componentType});
        }
        org.fabric3.api.model.type.component.Consumer consumer = new org.fabric3.api.model.type.component.Consumer(name, dataType, contract);
        if (annotation.group().length() > 0) {
            consumer.setGroup(annotation.group());
        }
        Class<?> clazz = field.getDeclaringClass();
        this.processSources(annotation, consumer, field, clazz, context);
        FieldInjectionSite injectionSite = new FieldInjectionSite(field);
        componentType.add(consumer, (InjectionSite)injectionSite, (AccessibleObject)field);
    }

    public void visitMethod(Consumer annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        int sequence;
        if (method.getParameterTypes().length > 1) {
            InvalidConsumerMethod failure = new InvalidConsumerMethod("Consumer method " + method + " has more than one parameter", method, componentType);
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        DataType type = this.introspectParameterType(method, typeMapping);
        String name = this.helper.getSiteName(method, annotation.value());
        JavaServiceContract contract = null;
        if (this.contractProcessor != null) {
            Class baseType = this.helper.getBaseType((Type)type.getType(), typeMapping);
            contract = this.contractProcessor.introspect(baseType, implClass, context, new ModelObject[]{componentType});
        }
        org.fabric3.api.model.type.component.Consumer consumer = new org.fabric3.api.model.type.component.Consumer(name, type, contract);
        if (annotation.group().length() > 0) {
            consumer.setGroup(annotation.group());
        }
        if ((sequence = annotation.sequence()) < 0) {
            context.addError((ValidationFailure)new InvalidConsumerMethod("Sequence number cannot be negative: " + method, method, componentType));
        } else {
            consumer.setSequence(sequence);
        }
        Class<?> clazz = method.getDeclaringClass();
        this.processSources(annotation, consumer, method, clazz, context);
        MethodInjectionSite injectionSite = new MethodInjectionSite(method, 0);
        componentType.add(consumer, (InjectionSite)injectionSite, (AccessibleObject)method);
    }

    private DataType introspectParameterType(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalParameterTypes = method.getParameterTypes();
        Type gParamType = method.getGenericParameterTypes()[0];
        Type logicalParamType = typeMapping.getActualType(gParamType);
        return this.createDataType(physicalParameterTypes[0], logicalParamType, typeMapping);
    }

    private DataType createDataType(Class<?> physicalType, Type type, TypeMapping mapping) {
        JavaType dataType;
        if (type instanceof Class) {
            dataType = new JavaType(physicalType);
        } else {
            JavaTypeInfo info = this.helper.createTypeInfo(type, mapping);
            dataType = new JavaGenericType(info);
        }
        for (TypeIntrospector introspector : this.typeIntrospectors) {
            introspector.introspect((DataType)dataType);
        }
        return dataType;
    }

    private void processSources(Consumer annotation, org.fabric3.api.model.type.component.Consumer consumer, AccessibleObject member, Class<?> clazz, IntrospectionContext context) {
        try {
            if (annotation.sources().length > 0) {
                for (String target : annotation.sources()) {
                    consumer.addSource(new URI(target));
                }
            } else if (annotation.source().length() > 0) {
                consumer.addSource(new URI(annotation.source()));
            }
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid consumer source on : " + clazz.getName(), (AnnotatedElement)member, (Annotation)annotation, clazz, (Exception)e);
            context.addError((ValidationFailure)error);
        }
    }
}

