/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AnnotationProcessor;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.oasisopen.sca.annotation.Reference;

public class DefaultClassVisitor
implements ClassVisitor {
    private Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> processors;
    private PolicyAnnotationProcessor policyProcessor;

    public DefaultClassVisitor(Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> processors) {
        this.processors = processors;
    }

    @org.oasisopen.sca.annotation.Constructor
    public DefaultClassVisitor() {
    }

    @Reference
    public void setProcessors(Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> processors) {
        this.processors = processors;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    public void visit(InjectingComponentType componentType, Class<?> clazz, IntrospectionContext context) {
        this.visit(componentType, clazz, clazz, false, context);
    }

    private void visit(InjectingComponentType componentType, Class<?> clazz, Class<?> implClass, boolean isSuperClass, IntrospectionContext context) {
        if (!clazz.isInterface()) {
            this.visitSuperClasses(componentType, clazz, implClass, context);
        }
        this.visitInterfaces(componentType, clazz, implClass, context);
        this.visitClass(componentType, clazz, context);
        this.visitFields(componentType, clazz, implClass, context);
        this.visitMethods(componentType, clazz, implClass, context);
        if (!isSuperClass) {
            this.visitConstructors(componentType, clazz, implClass, context);
        }
    }

    private void visitSuperClasses(InjectingComponentType componentType, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.visit(componentType, superClass, implClass, true, context);
        }
    }

    private void visitInterfaces(InjectingComponentType componentType, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Class<?> interfaze : clazz.getInterfaces()) {
            this.visit(componentType, interfaze, implClass, false, context);
        }
    }

    private void visitClass(InjectingComponentType componentType, Class<?> clazz, IntrospectionContext context) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            this.visitType(annotation, clazz, componentType, context);
        }
    }

    private void visitFields(InjectingComponentType componentType, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Field field : clazz.getDeclaredFields()) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
                this.visitField(annotation, field, implClass, componentType, context);
            }
            for (Annotation annotation : annotations) {
                for (Annotation metaAnnotation : annotation.annotationType().getDeclaredAnnotations()) {
                    if (this.skipAnnotation(metaAnnotation)) continue;
                    this.visitField(metaAnnotation, field, implClass, componentType, context);
                }
            }
        }
    }

    private void visitMethods(InjectingComponentType componentType, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Method method : clazz.getDeclaredMethods()) {
            Annotation[] declaredAnnotations;
            for (Annotation annotation : declaredAnnotations = method.getDeclaredAnnotations()) {
                this.visitMethod(annotation, method, implClass, componentType, context);
            }
            for (Annotation annotation : declaredAnnotations) {
                Annotation[] annotationArray = annotation.annotationType().getDeclaredAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation metaAnnotation = annotationArray[i];
                    if (this.skipAnnotation(metaAnnotation)) continue;
                    this.visitMethod(metaAnnotation, method, implClass, componentType, context);
                }
            }
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = parameterAnnotations[i]) {
                    this.visitMethodParameter(annotation, method, i, implClass, componentType, context);
                }
            }
        }
    }

    private void visitConstructors(InjectingComponentType componentType, Class<?> clazz, Class<?> implClass, IntrospectionContext context) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                this.visitConstructor(annotation, constructor, implClass, componentType, context);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = parameterAnnotations[i]) {
                    this.visitConstructorParameter(annotation, constructor, i, implClass, componentType, context);
                }
                for (Annotation annotation : annotations) {
                    for (Annotation metaAnnotation : annotation.annotationType().getDeclaredAnnotations()) {
                        if (this.skipAnnotation(metaAnnotation)) continue;
                        this.visitConstructorParameter(metaAnnotation, constructor, i, implClass, componentType, context);
                    }
                }
            }
        }
    }

    private <A extends Annotation> void visitType(A annotation, Class<?> clazz, InjectingComponentType componentType, IntrospectionContext context) {
        AnnotationProcessor<A> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitType(annotation, clazz, componentType, context);
        } else {
            if (this.policyProcessor != null) {
                this.policyProcessor.process(annotation, (PolicyAware)componentType, context);
            }
            for (Annotation metaAnnotation : annotation.annotationType().getDeclaredAnnotations()) {
                if (this.skipAnnotation(metaAnnotation)) continue;
                this.visitType(metaAnnotation, clazz, componentType, context);
            }
        }
    }

    private <A extends Annotation> void visitField(A annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        AnnotationProcessor<A> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitField(annotation, field, implClass, componentType, context);
        }
    }

    private <A extends Annotation> void visitMethod(A annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        AnnotationProcessor<A> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitMethod(annotation, method, implClass, componentType, context);
        } else if (this.policyProcessor != null) {
            this.policyProcessor.process(annotation, (PolicyAware)componentType, context);
        }
    }

    private <A extends Annotation> void visitMethodParameter(A annotation, Method method, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        AnnotationProcessor<A> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitMethodParameter(annotation, method, index, implClass, componentType, context);
        }
    }

    private <A extends Annotation> void visitConstructor(A annotation, Constructor<?> constructor, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        AnnotationProcessor<A> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitConstructor(annotation, constructor, implClass, componentType, context);
        }
    }

    private <A extends Annotation> void visitConstructorParameter(A annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        AnnotationProcessor<A> processor = this.getProcessor(annotation);
        if (processor != null) {
            processor.visitConstructorParameter(annotation, constructor, index, implClass, componentType, context);
        }
    }

    private boolean skipAnnotation(Annotation annotation) {
        Package pkg = annotation.annotationType().getPackage();
        return pkg != null && (pkg.getName().startsWith("java.") || pkg.getName().startsWith("javax."));
    }

    private <A extends Annotation> AnnotationProcessor<A> getProcessor(A annotation) {
        return this.processors.get(annotation.annotationType());
    }
}

