/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jndi.runtime;

import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.jndi.provision.PhysicalJndiContext;
import org.fabric3.jndi.spi.JndiContextManager;
import org.fabric3.spi.container.builder.ResourceBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JndiContextBuilder
implements ResourceBuilder<PhysicalJndiContext> {
    private JndiContextManager manager;

    public JndiContextBuilder(@Reference JndiContextManager manager) {
        this.manager = manager;
    }

    public void build(PhysicalJndiContext physicalContext) {
        for (Map.Entry<String, Properties> entry : physicalContext.getContexts().entrySet()) {
            try {
                this.manager.register(entry.getKey(), entry.getValue());
            }
            catch (NamingException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
    }

    public void remove(PhysicalJndiContext physicalContext) {
        for (String name : physicalContext.getContexts().keySet()) {
            try {
                this.manager.unregister(name);
            }
            catch (NamingException e) {
                throw new Fabric3Exception((Throwable)e);
            }
        }
    }
}

