/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jndi.introspection;

import java.util.HashMap;
import java.util.Properties;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.resource.jndi.JndiContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class JndiContextLoader
implements TypeLoader<JndiContext> {
    public JndiContext load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        HashMap<String, Properties> contexts = new HashMap<String, Properties>();
        Properties properties = null;
        while (true) {
            switch (reader.next()) {
                case 1: {
                    MissingAttribute error;
                    String name;
                    Location location = reader.getLocation();
                    if ("context".equals(reader.getName().getLocalPart())) {
                        name = reader.getAttributeValue(null, "name");
                        if (name == null) {
                            error = new MissingAttribute("Missing context name", location, new ModelObject[0]);
                            context.addError((ValidationFailure)error);
                            break;
                        }
                        properties = new Properties();
                        contexts.put(name, properties);
                        break;
                    }
                    if (!"property".equals(reader.getName().getLocalPart())) break;
                    if (properties == null) {
                        InvalidValue error2 = new InvalidValue("Invalid JNDI configuration", location, new ModelObject[0]);
                        context.addError((ValidationFailure)error2);
                        break;
                    }
                    name = reader.getAttributeValue(null, "name");
                    if (name == null) {
                        error = new MissingAttribute("Missing property name", location, new ModelObject[0]);
                        context.addError((ValidationFailure)error);
                        break;
                    }
                    String value = reader.getAttributeValue(null, "value");
                    if (value == null) {
                        MissingAttribute error3 = new MissingAttribute("Missing property value", location, new ModelObject[0]);
                        context.addError((ValidationFailure)error3);
                        break;
                    }
                    properties.put(name, value);
                    break;
                }
                case 2: {
                    if (!"jndi".equals(reader.getName().getLocalPart())) break;
                    return new JndiContext(contexts);
                }
            }
        }
    }
}

