/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.java.provision.JavaWireTarget;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.MethodUtils;
import org.fabric3.implementation.pojo.component.InvokerInterceptor;
import org.fabric3.implementation.pojo.provision.PojoWireSource;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvoker;
import org.fabric3.spi.container.builder.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.Reference;

public class JavaTargetWireAttacher
implements TargetWireAttacher<JavaWireTarget> {
    private final ComponentManager manager;
    private ReflectionFactory reflectionFactory;

    public JavaTargetWireAttacher(@Reference ComponentManager manager, @Reference ReflectionFactory reflectionFactory) {
        this.manager = manager;
        this.reflectionFactory = reflectionFactory;
    }

    public void attach(PhysicalWireSource source, JavaWireTarget target, Wire wire) {
        URI targetName = UriHelper.getDefragmentedName((URI)target.getUri());
        Component component = this.manager.getComponent(targetName);
        if (component == null) {
            throw new Fabric3Exception("Target not found: " + targetName);
        }
        JavaComponent javaComponent = (JavaComponent)component;
        Class implementationClass = javaComponent.getImplementationClass();
        ClassLoader loader = target.getClassLoader();
        for (InvocationChain chain : wire.getInvocationChains()) {
            PhysicalOperation operation = chain.getPhysicalOperation();
            Method method = MethodUtils.findMethod((PhysicalWireSource)source, (PhysicalWireTarget)target, (PhysicalOperation)operation, (Class)implementationClass, (ClassLoader)loader);
            ServiceInvoker invoker = this.reflectionFactory.createServiceInvoker(method);
            InvokerInterceptor interceptor = source instanceof PojoWireSource && target.getClassLoader().equals(source.getClassLoader()) ? new InvokerInterceptor(invoker, (AtomicComponent)javaComponent) : new InvokerInterceptor(invoker, (AtomicComponent)javaComponent, loader);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public Supplier<?> createSupplier(JavaWireTarget target) {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        JavaComponent targetComponent = (JavaComponent)this.manager.getComponent(targetId);
        return targetComponent.createSupplier();
    }
}

