/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.implementation.java.provision.JavaWireSource;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.PojoSourceWireAttacher;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.spi.container.builder.SourceWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaSourceWireAttacher
extends PojoSourceWireAttacher
implements SourceWireAttacher<JavaWireSource> {
    private ComponentManager manager;
    private WireProxyService proxyService;

    public JavaSourceWireAttacher(@Reference ComponentManager manager, @Reference WireProxyService proxyService, @Reference TransformerRegistry transformerRegistry) {
        super(transformerRegistry);
        this.manager = manager;
        this.proxyService = proxyService;
    }

    public void attach(JavaWireSource source, PhysicalWireTarget target, Wire wire) {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        if (component == null) {
            throw new Fabric3Exception("Source callback not found: " + sourceName);
        }
        Injectable injectable = source.getInjectable();
        Class type = source.getInterfaceClass();
        if (InjectableType.CALLBACK.equals((Object)injectable.getType())) {
            this.processCallback(wire, target, component, injectable, type);
        } else {
            this.processReference(wire, source, target, component, injectable, type);
        }
    }

    public void detach(JavaWireSource source, PhysicalWireTarget target) {
        this.detachSupplier(source, target);
    }

    public void detachSupplier(JavaWireSource source, PhysicalWireTarget target) {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeSupplier(injectable);
    }

    public void attachSupplier(JavaWireSource source, Supplier<?> supplier, PhysicalWireTarget targetDefinition) {
        URI sourceId = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent sourceComponent = (JavaComponent)this.manager.getComponent(sourceId);
        Injectable injectable = source.getInjectable();
        if (source.isKeyed() || source.isOrdered()) {
            Object key = this.getKey(source, targetDefinition);
            int order = source.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            sourceComponent.setSupplier(injectable, supplier, attributes);
        } else {
            sourceComponent.setSupplier(injectable, supplier);
        }
    }

    private void processReference(Wire wire, JavaWireSource source, PhysicalWireTarget target, JavaComponent component, Injectable injectable, Class<?> type) {
        String callbackUri = null;
        URI uri = target.getCallbackUri();
        if (uri != null) {
            callbackUri = uri.toString();
        }
        Supplier supplier = this.proxyService.createSupplier(type, wire, callbackUri);
        if (source.isKeyed() || source.isOrdered()) {
            Object key = this.getKey(source, target);
            int order = source.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            component.setSupplier(injectable, supplier, attributes);
        } else {
            component.setSupplier(injectable, supplier);
        }
    }

    private void processCallback(Wire wire, PhysicalWireTarget targetDefinition, JavaComponent source, Injectable injectable, Class<?> type) {
        URI callbackUri = targetDefinition.getUri();
        ScopeContainer container = source.getScopeContainer();
        Supplier supplier = source.getSupplier(injectable);
        boolean multiThreaded = Scope.COMPOSITE.equals((Object)container.getScope());
        supplier = supplier == null ? this.proxyService.createCallbackSupplier(type, multiThreaded, callbackUri, wire) : this.proxyService.updateCallbackSupplier(supplier, type, multiThreaded, callbackUri, wire);
        source.setSupplier(injectable, supplier);
    }
}

