/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.java.provision.JavaConnectionSource;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.spi.proxy.ChannelProxyService;
import org.fabric3.spi.container.builder.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaSourceConnectionAttacher
implements SourceConnectionAttacher<JavaConnectionSource> {
    private ComponentManager manager;
    private ChannelProxyService proxyService;

    public JavaSourceConnectionAttacher(@Reference ComponentManager manager, @Reference ChannelProxyService proxyService) {
        this.manager = manager;
        this.proxyService = proxyService;
    }

    public void attach(JavaConnectionSource source, PhysicalConnectionTarget target, ChannelConnection connection) {
        URI sourceUri = source.getUri();
        URI sourceName = UriHelper.getDefragmentedName((URI)sourceUri);
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        if (component == null) {
            throw new Fabric3Exception("Source component not found: " + sourceName);
        }
        Injectable injectable = source.getInjectable();
        Class type = source.getServiceInterface();
        Supplier supplier = source.isDirectConnection() ? (Supplier)connection.getDirectConnection().get() : this.proxyService.createSupplier(type, connection);
        component.setSupplier(injectable, supplier);
    }

    public void detach(JavaConnectionSource source, PhysicalConnectionTarget target) {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeSupplier(injectable);
    }
}

