/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.implementation.java.provision.PhysicalJavaComponent;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.java.runtime.NonManagedImplementationManagerFactory;
import org.fabric3.implementation.pojo.builder.PojoComponentBuilder;
import org.fabric3.implementation.pojo.builder.PropertySupplierBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaComponentBuilder
extends PojoComponentBuilder<PhysicalJavaComponent, JavaComponent> {
    private ImplementationManagerFactoryBuilder factoryBuilder;

    public JavaComponentBuilder(@Reference ImplementationManagerFactoryBuilder factoryBuilder, @Reference PropertySupplierBuilder propertyBuilder, @Reference ManagementService managementService, @Reference IntrospectionHelper helper, @Reference HostInfo info) {
        super(propertyBuilder, managementService, helper, info);
        this.factoryBuilder = factoryBuilder;
    }

    public JavaComponent build(PhysicalJavaComponent physicalComponent) {
        return physicalComponent.getInstance() != null ? this.buildNonManagedComponent(physicalComponent) : this.buildManagedComponent(physicalComponent);
    }

    public void dispose(PhysicalJavaComponent physicalComponent, JavaComponent component) {
        this.dispose(physicalComponent);
    }

    private JavaComponent buildManagedComponent(PhysicalJavaComponent physicalComponent) {
        URI uri = physicalComponent.getComponentUri();
        Scope scopeName = physicalComponent.getScope();
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(scopeName);
        ImplementationManagerDefinition managerDefinition = physicalComponent.getFactoryDefinition();
        ImplementationManagerFactory factory = this.factoryBuilder.build(managerDefinition);
        boolean eager = physicalComponent.isEagerInit();
        URI contributionUri = physicalComponent.getContributionUri();
        JavaComponent component = new JavaComponent(uri, factory, scopeContainer, eager, contributionUri);
        this.createPropertyFactories(physicalComponent, component, factory);
        this.buildContexts(component, factory);
        this.export(physicalComponent, (AtomicComponent)component);
        return component;
    }

    private JavaComponent buildNonManagedComponent(PhysicalJavaComponent physicalComponent) {
        URI componentUri = physicalComponent.getComponentUri();
        Scope scopeName = physicalComponent.getScope();
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(scopeName);
        Object instance = physicalComponent.getInstance();
        NonManagedImplementationManagerFactory factory = new NonManagedImplementationManagerFactory(instance);
        URI contributionUri = physicalComponent.getContributionUri();
        return new JavaComponent(componentUri, factory, scopeContainer, false, contributionUri);
    }
}

