/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.util.Set;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class JavaServiceHeuristic
implements HeuristicProcessor {
    private IntrospectionHelper helper;
    private JavaContractProcessor contractProcessor;
    private OperationPolicyIntrospector policyIntrospector;

    public JavaServiceHeuristic(@Reference IntrospectionHelper helper, @Reference JavaContractProcessor contractProcessor, @Reference OperationPolicyIntrospector policyIntrospector) {
        this.helper = helper;
        this.contractProcessor = contractProcessor;
        this.policyIntrospector = policyIntrospector;
    }

    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        if (!componentType.getServices().isEmpty()) {
            for (Service definition : componentType.getServices().values()) {
                JavaServiceContract contract = (JavaServiceContract)definition.getServiceContract();
                this.policyIntrospector.introspectPolicyOnOperations((ServiceContract)contract, implClass, context);
            }
            return;
        }
        Set interfaces = this.helper.getImplementedInterfaces(implClass);
        if (interfaces.isEmpty()) {
            Service<ComponentType> service = this.createServiceDefinition(implClass, implClass, (ComponentType)componentType, context);
            componentType.add(service);
        } else {
            for (Class interfaze : interfaces) {
                Package pkg = interfaze.getPackage();
                if (interfaze.isAnnotationPresent(Management.class) || pkg == null || pkg.getName().startsWith("java")) continue;
                Service<ComponentType> service = this.createServiceDefinition(interfaze, implClass, (ComponentType)componentType, context);
                componentType.add(service);
            }
        }
    }

    private Service<ComponentType> createServiceDefinition(Class<?> serviceInterface, Class<?> implClass, ComponentType componentType, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, context, new ModelObject[]{componentType});
        Service definition = new Service(contract.getInterfaceName(), (ServiceContract)contract);
        this.policyIntrospector.introspectPolicyOnOperations((ServiceContract)contract, implClass, context);
        return definition;
    }
}

