/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.implementation.java.introspection.ImplementationArtifactNotFound;
import org.fabric3.implementation.java.introspection.JavaImplementationIntrospector;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
@Key(value="{http://docs.oasis-open.org/ns/opencsa/sca/200912}implementation.java")
public class JavaImplementationLoader
extends AbstractValidatingTypeLoader<JavaImplementation> {
    private JavaImplementationIntrospector introspector;

    public JavaImplementationLoader(@Reference JavaImplementationIntrospector introspector, @Reference LoaderHelper loaderHelper) {
        this.introspector = introspector;
        this.addAttributes(new String[]{"class", "requires", "policySets"});
    }

    public JavaImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        Class<?> clazz;
        Location startLocation = reader.getLocation();
        JavaImplementation implementation = new JavaImplementation();
        this.validateAttributes(reader, introspectionContext, new ModelObject[]{implementation});
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("The class attribute was not specified", startLocation, new ModelObject[0]);
            introspectionContext.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return implementation;
        }
        try {
            clazz = introspectionContext.getClassLoader().loadClass(implClass);
        }
        catch (ClassNotFoundException e) {
            ImplementationArtifactNotFound failure = new ImplementationArtifactNotFound(implClass, e.getMessage(), (ModelObject)implementation);
            introspectionContext.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return null;
        }
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        implementation.setImplementationClass(clazz);
        InjectingComponentType componentType = new InjectingComponentType(clazz);
        this.introspector.introspect(componentType, introspectionContext);
        implementation.setComponentType((ComponentType)componentType);
        return implementation;
    }
}

