/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.util.Collections;
import java.util.List;
import org.fabric3.api.annotation.wire.Key;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.implementation.java.introspection.EagerInitNotSupported;
import org.fabric3.implementation.java.introspection.ImplementationArtifactNotFound;
import org.fabric3.implementation.java.introspection.JavaImplementationIntrospector;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidImplementation;
import org.fabric3.spi.introspection.java.PostProcessor;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.oasisopen.sca.annotation.Reference;

@Key(value="java")
public class JavaImplementationIntrospectorImpl
implements JavaImplementationIntrospector {
    private final ClassVisitor classVisitor;
    private final HeuristicProcessor heuristic;
    private final IntrospectionHelper helper;
    private List<PostProcessor> postProcessors = Collections.emptyList();

    @Reference(required=false)
    public void setPostProcessors(List<PostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public JavaImplementationIntrospectorImpl(@Reference(name="classVisitor") ClassVisitor classVisitor, @Reference(name="heuristic") HeuristicProcessor heuristic, @Reference(name="helper") IntrospectionHelper helper) {
        this.classVisitor = classVisitor;
        this.heuristic = heuristic;
        this.helper = helper;
    }

    public void introspect(InjectingComponentType componentType, IntrospectionContext context) {
        componentType.setScope(Scope.STATELESS);
        Class implClass = componentType.getImplClass();
        if (implClass.isInterface()) {
            InvalidImplementation failure = new InvalidImplementation("Implementation class is an interface", implClass, componentType);
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping mapping = context.getTypeMapping(implClass);
        if (mapping == null) {
            mapping = new TypeMapping();
            context.addTypeMapping(implClass, mapping);
            this.helper.resolveTypeParameters(implClass, mapping);
        }
        try {
            this.classVisitor.visit(componentType, implClass, context);
            this.heuristic.applyHeuristics(componentType, implClass, context);
        }
        catch (NoClassDefFoundError e) {
            context.addError((ValidationFailure)new ImplementationArtifactNotFound(implClass.getName(), e.getMessage(), (ModelObject)componentType));
        }
        this.validateScope(componentType, implClass, context);
        for (PostProcessor postProcessor : this.postProcessors) {
            postProcessor.process(componentType, implClass, context);
        }
    }

    private void validateScope(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Scope scope = componentType.getScope();
        if (componentType.isEagerInit() && Scope.COMPOSITE != scope && Scope.DOMAIN != scope) {
            EagerInitNotSupported warning = new EagerInitNotSupported(implClass, componentType);
            context.addWarning((ValidationFailure)warning);
        }
    }
}

