/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.fabric3.api.annotation.Producer;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Property;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.java.introspection.IllegalManagementAttribute;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.MultiplicityType;
import org.fabric3.spi.introspection.java.NoConstructorFound;
import org.fabric3.spi.introspection.java.UnknownInjectionType;
import org.fabric3.spi.introspection.java.annotation.AmbiguousConstructor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Constructor;

public class JavaHeuristic
implements HeuristicProcessor {
    private IntrospectionHelper helper;
    private JavaContractProcessor contractProcessor;
    private final HeuristicProcessor serviceHeuristic;

    public JavaHeuristic(@org.oasisopen.sca.annotation.Reference IntrospectionHelper helper, @org.oasisopen.sca.annotation.Reference JavaContractProcessor contractProcessor, @org.oasisopen.sca.annotation.Reference(name="service") HeuristicProcessor serviceHeuristic) {
        this.helper = helper;
        this.contractProcessor = contractProcessor;
        this.serviceHeuristic = serviceHeuristic;
    }

    public void applyHeuristics(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        this.serviceHeuristic.applyHeuristics(componentType, implClass, context);
        if (componentType.getConstructor() == null) {
            java.lang.reflect.Constructor<?> ctor = this.findConstructor(implClass, componentType, context);
            componentType.setConstructor(ctor);
        }
        if (componentType.getProperties().isEmpty() && componentType.getReferences().isEmpty() && componentType.getResourceReferences().isEmpty()) {
            this.evaluateConstructor(componentType, implClass, context);
            this.evaluateSetters(componentType, implClass, context);
            this.evaluateFields(componentType, implClass, context);
        }
        Scope scope = componentType.getScope();
        if (componentType.isManaged() && !scope.isSingleton()) {
            IllegalManagementAttribute warning = new IllegalManagementAttribute(implClass, componentType);
            context.addWarning((ValidationFailure)warning);
        }
    }

    private java.lang.reflect.Constructor<?> findConstructor(Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        java.lang.reflect.Constructor<?>[] constructors = implClass.getDeclaredConstructors();
        java.lang.reflect.Constructor<?> selected = null;
        if (constructors.length == 1) {
            selected = constructors[0];
        } else {
            for (java.lang.reflect.Constructor<?> constructor : constructors) {
                if (!constructor.isAnnotationPresent(Constructor.class)) continue;
                if (selected != null) {
                    context.addError((ValidationFailure)new AmbiguousConstructor(implClass, componentType));
                    return null;
                }
                selected = constructor;
            }
            if (selected == null) {
                for (java.lang.reflect.Constructor<?> constructor : constructors) {
                    Annotation[][] annotationArray = constructor.getParameterAnnotations();
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = annotationArray[i]) {
                            if (!annotation.annotationType().equals(org.oasisopen.sca.annotation.Reference.class) && !annotation.annotationType().equals(Producer.class) && !annotation.annotationType().equals(Monitor.class)) continue;
                            if (selected != null) {
                                context.addError((ValidationFailure)new AmbiguousConstructor(implClass, componentType));
                                return null;
                            }
                            selected = constructor;
                        }
                    }
                }
                if (selected == null) {
                    try {
                        selected = implClass.getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        context.addError((ValidationFailure)new NoConstructorFound(implClass, componentType));
                        return null;
                    }
                }
            }
        }
        return selected;
    }

    private void evaluateConstructor(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        java.lang.reflect.Constructor constructor = componentType.getConstructor();
        if (constructor == null) {
            return;
        }
        Map sites = componentType.getInjectionSites();
        Type[] parameterTypes = constructor.getGenericParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, i);
            if (sites.containsKey(site)) continue;
            TypeMapping typeMapping = context.getTypeMapping(implClass);
            Class parameterType = this.helper.getBaseType(parameterTypes[i], typeMapping);
            String name = this.helper.getSiteName(constructor, i, null);
            this.processSite(componentType, name, constructor, parameterType, implClass, (InjectionSite)site, context);
        }
    }

    private void evaluateSetters(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Map sites = componentType.getInjectionSites();
        Set setters = this.helper.getInjectionMethods(implClass, componentType.getServices().values());
        for (Method setter : setters) {
            MethodInjectionSite site = new MethodInjectionSite(setter, 0);
            if (sites.containsKey(site)) continue;
            String name = this.helper.getSiteName(setter, null);
            TypeMapping typeMapping = context.getTypeMapping(implClass);
            Type genericType = setter.getGenericParameterTypes()[0];
            Class parameterType = this.helper.getBaseType(genericType, typeMapping);
            this.processSite(componentType, name, setter, parameterType, implClass, (InjectionSite)site, context);
        }
    }

    private void evaluateFields(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Map sites = componentType.getInjectionSites();
        Set fields = this.helper.getInjectionFields(implClass);
        for (Field field : fields) {
            FieldInjectionSite site = new FieldInjectionSite(field);
            if (sites.containsKey(site)) continue;
            String name = this.helper.getSiteName(field, null);
            TypeMapping typeMapping = context.getTypeMapping(implClass);
            Class parameterType = this.helper.getBaseType(field.getGenericType(), typeMapping);
            this.processSite(componentType, name, field, parameterType, implClass, (InjectionSite)site, context);
        }
    }

    private void processSite(InjectingComponentType componentType, String name, Member member, Class<?> parameterType, Class<?> declaringClass, InjectionSite site, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(declaringClass);
        InjectableType type = this.helper.inferType(parameterType, typeMapping);
        switch (type) {
            case PROPERTY: {
                this.addProperty(componentType, name, parameterType, declaringClass, site, context);
                break;
            }
            case REFERENCE: {
                this.addReference(componentType, name, parameterType, declaringClass, site, context);
                break;
            }
            case CALLBACK: {
                context.addError((ValidationFailure)new UnknownInjectionType(site, type, componentType.getImplClass().getName(), member, (ComponentType)componentType));
                break;
            }
            default: {
                context.addError((ValidationFailure)new UnknownInjectionType(site, type, componentType.getImplClass().getName(), member, (ComponentType)componentType));
            }
        }
    }

    private void addProperty(InjectingComponentType componentType, String name, Type type, Class<?> declaringClass, InjectionSite site, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(declaringClass);
        Property property = new Property(name);
        MultiplicityType multiplicityType = this.helper.introspectMultiplicity(type, typeMapping);
        property.setMany(MultiplicityType.COLLECTION == multiplicityType || MultiplicityType.DICTIONARY == multiplicityType);
        componentType.add(property, site);
    }

    private void addReference(InjectingComponentType componentType, String name, Class<?> parameterType, Class<?> declaringClass, InjectionSite site, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(declaringClass);
        JavaServiceContract contract = this.contractProcessor.introspect(parameterType, context, new ModelObject[]{componentType});
        Reference reference = new Reference(name, (ServiceContract)contract);
        this.helper.processMultiplicity(reference, false, parameterType, typeMapping);
        componentType.add(reference, site);
    }
}

