/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fabric3.api.annotation.Consumer;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.implementation.java.introspection.JavaImplementationIntrospector;
import org.fabric3.implementation.java.introspection.MultipleInterfacesSupported;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.PostProcessor;
import org.fabric3.spi.introspection.java.annotation.AnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public abstract class AbstractPojoImplementationProcessor
implements ImplementationProcessor<JavaImplementation> {
    private JavaContractProcessor contractProcessor;
    private JavaImplementationIntrospector introspector;
    private IntrospectionHelper helper;
    private Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> annotationProcessors;
    private List<PostProcessor> postProcessors = Collections.emptyList();

    @Reference(required=false)
    public void setPostProcessors(List<PostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    @Reference
    public void setAnnotationProcessors(Map<Class<? extends Annotation>, AnnotationProcessor<? extends Annotation>> processors) {
        this.annotationProcessors = processors;
    }

    public AbstractPojoImplementationProcessor(@Reference JavaContractProcessor contractProcessor, @Reference JavaImplementationIntrospector introspector, @Reference IntrospectionHelper helper) {
        this.contractProcessor = contractProcessor;
        this.introspector = introspector;
        this.helper = helper;
    }

    public void process(Component<JavaImplementation> component, IntrospectionContext context) {
        JavaImplementation implementation = (JavaImplementation)component.getImplementation();
        Object instance = implementation.getInstance();
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        if (instance == null) {
            this.introspector.introspect(componentType, context);
        } else {
            componentType.setScope(Scope.COMPOSITE);
            if (componentType.getServices().isEmpty()) {
                this.addServiceDefinitions(instance, componentType, context);
            }
            this.processAnnotations(instance, component, context);
            for (PostProcessor postProcessor : this.postProcessors) {
                postProcessor.process(componentType, instance.getClass(), context);
            }
        }
    }

    public void process(Component<JavaImplementation> component, Class<?> clazz, IntrospectionContext context) {
        JavaImplementation implementation = this.createImplementation(clazz, context);
        component.setImplementation((Implementation)implementation);
        this.process(component, context);
    }

    protected abstract JavaImplementation createImplementation(Class<?> var1, IntrospectionContext var2);

    private void processAnnotations(Object instance, Component<?> definition, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)definition.getComponentType();
        Class<?> implClass = instance.getClass();
        AnnotationProcessor<? extends Annotation> consumerProcessor = this.annotationProcessors.get(Consumer.class);
        for (Method method : implClass.getDeclaredMethods()) {
            Consumer consumer = method.getAnnotation(Consumer.class);
            if (consumer == null) continue;
            TypeMapping mapping = context.getTypeMapping(implClass);
            if (mapping == null) {
                mapping = new TypeMapping();
                context.addTypeMapping(implClass, mapping);
            }
            this.helper.resolveTypeParameters(implClass, mapping);
            consumerProcessor.visitMethod((Annotation)consumer, method, implClass, componentType, context);
        }
        for (org.fabric3.api.model.type.component.Consumer consumer : componentType.getConsumers().values()) {
            String name = consumer.getName();
            org.fabric3.api.model.type.component.Consumer componentConsumer = new org.fabric3.api.model.type.component.Consumer(name);
            componentConsumer.setSources(Collections.singletonList(URI.create(name)));
            definition.add(componentConsumer);
        }
    }

    private void addServiceDefinitions(Object instance, InjectingComponentType componentType, IntrospectionContext context) {
        Class<?> serviceInterface;
        Class<?> implClass = instance.getClass();
        Class<?>[] interfaces = implClass.getInterfaces();
        if (interfaces.length == 0) {
            serviceInterface = implClass;
        } else if (interfaces.length == 1) {
            serviceInterface = interfaces[0];
        } else {
            MultipleInterfacesSupported failure = new MultipleInterfacesSupported(implClass, componentType);
            context.addError((ValidationFailure)failure);
            return;
        }
        String serviceName = serviceInterface.getSimpleName();
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, context, new ModelObject[0]);
        Service service = new Service(serviceName, (ServiceContract)contract);
        componentType.add(service);
    }
}

