/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.generator;

import java.lang.reflect.AccessibleObject;
import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Callback;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.implementation.java.generator.JavaGenerationHelper;
import org.fabric3.implementation.java.provision.JavaConnectionSource;
import org.fabric3.implementation.java.provision.JavaConnectionTarget;
import org.fabric3.implementation.java.provision.JavaWireSource;
import org.fabric3.implementation.java.provision.JavaWireTarget;
import org.fabric3.implementation.java.provision.PhysicalJavaComponent;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.pojo.provision.PhysicalPojoComponent;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.Reference;

public class JavaGenerationHelperImpl
implements JavaGenerationHelper {
    private final GenerationHelper helper;
    private ContractMatcher matcher;

    public JavaGenerationHelperImpl(@Reference GenerationHelper helper, @Reference ContractMatcher matcher) {
        this.helper = helper;
        this.matcher = matcher;
    }

    @Override
    public void generate(PhysicalJavaComponent physicalComponent, LogicalComponent<? extends JavaImplementation> component) {
        Component logical = component.getDefinition();
        JavaImplementation implementation = (JavaImplementation)logical.getImplementation();
        InjectingComponentType type = (InjectingComponentType)implementation.getComponentType();
        Scope scope = type.getScope();
        ImplementationManagerDefinition managerDefinition = new ImplementationManagerDefinition();
        managerDefinition.setReinjectable(Scope.COMPOSITE == scope);
        managerDefinition.setConstructor(type.getConstructor());
        managerDefinition.setInitMethod(type.getInitMethod());
        managerDefinition.setDestroyMethod(type.getDestroyMethod());
        managerDefinition.setImplementationClass(implementation.getImplementationClass());
        managerDefinition.setClassLoaderUri(component.getDefinition().getContributionUri());
        this.helper.processInjectionSites(type, managerDefinition);
        physicalComponent.setScope(scope);
        physicalComponent.setEagerInit(type.isEagerInit());
        physicalComponent.setManagerDefinition(managerDefinition);
        physicalComponent.setManaged(type.isManaged());
        physicalComponent.setManagementInfo(type.getManagementInfo());
        this.helper.processPropertyValues(component, (PhysicalPojoComponent)physicalComponent);
    }

    @Override
    public void generateWireSource(JavaWireSource source, LogicalReference reference) {
        URI uri = reference.getUri();
        JavaServiceContract serviceContract = (JavaServiceContract)reference.getDefinition().getServiceContract();
        source.setUri(uri);
        source.setInjectable(new Injectable(InjectableType.REFERENCE, uri.getFragment()));
        source.setInterfaceClass(serviceContract.getInterfaceClass());
        source.setOptimizable(true);
        if (reference.getDefinition().isKeyed()) {
            source.setKeyed(true);
            DataType type = reference.getDefinition().getKeyDataType();
            String className = type.getType().getName();
            source.setKeyClassName(className);
        }
    }

    @Override
    public void generateConnectionSource(JavaConnectionSource source, LogicalProducer producer) {
        URI uri = producer.getUri();
        source.setUri(uri);
        ServiceContract serviceContract = producer.getDefinition().getServiceContract();
        Class interfaze = serviceContract.getInterfaceClass();
        source.setInjectable(new Injectable(InjectableType.PRODUCER, uri.getFragment()));
        source.setServiceInterface(interfaze);
    }

    @Override
    public void generateConnectionTarget(JavaConnectionTarget target, LogicalConsumer consumer) {
        Injectable injectable = new Injectable(InjectableType.CONSUMER, consumer.getUri().getFragment());
        target.setInjectable(injectable);
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        URI uri = component.getUri();
        target.setUri(uri);
        ServiceContract serviceContract = consumer.getDefinition().getServiceContract();
        Class interfaze = serviceContract.getInterfaceClass();
        target.setServiceInterface(interfaze);
        InjectingComponentType type = (InjectingComponentType)((JavaImplementation)component.getDefinition().getImplementation()).getComponentType();
        AccessibleObject object = type.getConsumerSite(consumer.getUri().getFragment());
        if (object == null) {
            throw new Fabric3Exception("Consumer not found on: " + consumer.getUri());
        }
        target.setConsumerSite(object);
    }

    @Override
    public void generateCallbackWireSource(JavaWireSource source, LogicalComponent<? extends JavaImplementation> component, JavaServiceContract contract) {
        InjectingComponentType type = (InjectingComponentType)((JavaImplementation)component.getDefinition().getImplementation()).getComponentType();
        String name = null;
        for (Callback entry : type.getCallbacks().values()) {
            ServiceContract candidate = entry.getServiceContract();
            MatchResult result = this.matcher.isAssignableFrom(candidate, (ServiceContract)contract, false);
            if (!result.isAssignable()) continue;
            name = entry.getName();
            break;
        }
        if (name == null) {
            String interfaze = contract.getQualifiedInterfaceName();
            throw new Fabric3Exception("Callback injection site not found for type: " + interfaze);
        }
        Injectable injectable = new Injectable(InjectableType.CALLBACK, name);
        source.setInjectable(injectable);
        source.setInterfaceClass(contract.getInterfaceClass());
        URI uri = URI.create(component.getUri().toString() + "#" + name);
        source.setUri(uri);
        source.setOptimizable(false);
    }

    @Override
    public void generateResourceWireSource(JavaWireSource source, LogicalResourceReference<?> resourceReference) {
        URI uri = resourceReference.getUri();
        JavaServiceContract serviceContract = (JavaServiceContract)resourceReference.getDefinition().getServiceContract();
        source.setUri(uri);
        source.setInjectable(new Injectable(InjectableType.RESOURCE, uri.getFragment()));
        source.setInterfaceClass(serviceContract.getInterfaceClass());
    }

    @Override
    public void generateWireTarget(JavaWireTarget target, LogicalService service) {
        LogicalComponent component = (LogicalComponent)service.getParent();
        URI uri = URI.create(component.getUri().toString() + "#" + service.getUri().getFragment());
        target.setUri(uri);
        Component componentDefinition = component.getDefinition();
        JavaImplementation implementation = (JavaImplementation)componentDefinition.getImplementation();
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        Scope scope = componentType.getScope();
        target.setOptimizable(scope.isSingleton());
    }
}

