/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.generator;

import org.fabric3.api.model.type.component.Scope;
import org.fabric3.api.model.type.java.JavaImplementation;
import org.fabric3.implementation.java.generator.JavaGenerationHelper;
import org.fabric3.implementation.java.provision.JavaConnectionSource;
import org.fabric3.implementation.java.provision.JavaConnectionTarget;
import org.fabric3.implementation.java.provision.JavaWireSource;
import org.fabric3.implementation.java.provision.JavaWireTarget;
import org.fabric3.implementation.java.provision.PhysicalJavaComponent;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.spi.domain.generator.ComponentGenerator;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.physical.PhysicalComponent;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.fabric3.spi.model.physical.PhysicalConnectionTarget;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JavaComponentGenerator
implements ComponentGenerator<LogicalComponent<JavaImplementation>> {
    protected final GenerationHelper ifHelper;
    private JavaGenerationHelper generationHelper;

    public JavaComponentGenerator(@Reference JavaGenerationHelper generationHelper, @Reference GenerationHelper ifHelper) {
        this.generationHelper = generationHelper;
        this.ifHelper = ifHelper;
    }

    public PhysicalComponent generate(LogicalComponent<JavaImplementation> component) {
        Object instance = ((JavaImplementation)component.getDefinition().getImplementation()).getInstance();
        if (instance != null) {
            PhysicalJavaComponent physicalComponent = new PhysicalJavaComponent(instance);
            physicalComponent.setScope(Scope.COMPOSITE);
            return physicalComponent;
        }
        PhysicalJavaComponent physicalComponent = new PhysicalJavaComponent();
        this.generationHelper.generate(physicalComponent, component);
        return physicalComponent;
    }

    public PhysicalWireSource generateSource(LogicalReference reference) {
        JavaWireSource source = new JavaWireSource();
        this.generationHelper.generateWireSource(source, reference);
        return source;
    }

    public PhysicalWireSource generateCallbackSource(LogicalService service) {
        JavaWireSource source = new JavaWireSource();
        JavaServiceContract callbackContract = (JavaServiceContract)service.getDefinition().getServiceContract().getCallbackContract();
        LogicalComponent component = (LogicalComponent)service.getParent();
        this.generationHelper.generateCallbackWireSource(source, (LogicalComponent<? extends JavaImplementation>)component, callbackContract);
        return source;
    }

    public PhysicalWireTarget generateTarget(LogicalService service) {
        JavaWireTarget target = new JavaWireTarget();
        this.generationHelper.generateWireTarget(target, service);
        return target;
    }

    public PhysicalConnectionSource generateConnectionSource(LogicalProducer producer) {
        JavaConnectionSource source = new JavaConnectionSource();
        this.generationHelper.generateConnectionSource(source, producer);
        return source;
    }

    public PhysicalConnectionTarget generateConnectionTarget(LogicalConsumer consumer) {
        JavaConnectionTarget target = new JavaConnectionTarget();
        this.generationHelper.generateConnectionTarget(target, consumer);
        return target;
    }

    public PhysicalWireSource generateResourceSource(LogicalResourceReference<?> resourceReference) {
        JavaWireSource source = new JavaWireSource();
        this.generationHelper.generateResourceWireSource(source, resourceReference);
        return source;
    }
}

