/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.singleton;

import java.net.URI;
import java.util.function.Supplier;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.system.singleton.SingletonComponent;
import org.fabric3.implementation.system.singleton.SingletonWireSource;
import org.fabric3.spi.container.builder.SourceWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SingletonSourceWireAttacher
implements SourceWireAttacher<SingletonWireSource> {
    private ComponentManager manager;

    public SingletonSourceWireAttacher(@Reference ComponentManager manager) {
        this.manager = manager;
    }

    public void attach(SingletonWireSource source, PhysicalWireTarget target, Wire wire) {
        throw new UnsupportedOperationException();
    }

    public void detach(SingletonWireSource source, PhysicalWireTarget target) {
    }

    public void detachSupplier(SingletonWireSource source, PhysicalWireTarget target) {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SingletonComponent component = (SingletonComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeSupplier(injectable);
    }

    public void attachSupplier(SingletonWireSource source, Supplier<?> supplier, PhysicalWireTarget target) {
        URI sourceId = UriHelper.getDefragmentedName((URI)source.getUri());
        SingletonComponent sourceComponent = (SingletonComponent)this.manager.getComponent(sourceId);
        Injectable injectable = source.getInjectable();
        String key = source.getKey();
        int order = source.getOrder();
        InjectionAttributes attributes = new InjectionAttributes((Object)key, order);
        sourceComponent.addSupplier(injectable, supplier, attributes);
    }
}

