/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.singleton;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.pojo.supplier.ArrayMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.ListMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.MapMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.MultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.SetMultiplicitySupplier;
import org.fabric3.spi.container.component.ScopedComponent;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

public class SingletonComponent
implements ScopedComponent {
    private final URI uri;
    private Object instance;
    private Map<Member, Injectable> sites;
    private Map<Supplier, Injectable> reinjectionMappings;
    private URI contributionUri;
    private MonitorLevel level = MonitorLevel.INFO;
    private AtomicBoolean started = new AtomicBoolean(false);

    public SingletonComponent(URI componentId, Object instance, Map<InjectionSite, Injectable> mappings, URI contributionUri) {
        this.uri = componentId;
        this.instance = instance;
        this.contributionUri = contributionUri;
        this.reinjectionMappings = new HashMap<Supplier, Injectable>();
        this.initializeInjectionSites(mappings);
    }

    public URI getContributionUri() {
        return this.contributionUri;
    }

    public String getKey() {
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    public void start() {
        this.started.set(true);
    }

    public void stop() {
        this.started.set(false);
    }

    public void startUpdate() {
        this.reinjectionMappings.keySet().stream().filter(factory -> factory instanceof MultiplicitySupplier).forEach(factory -> ((MultiplicitySupplier)factory).startUpdate());
    }

    public void endUpdate() {
        this.reinjectionMappings.keySet().stream().filter(factory -> factory instanceof MultiplicitySupplier).forEach(factory -> ((MultiplicitySupplier)factory).endUpdate());
    }

    public boolean isEagerInit() {
        return true;
    }

    public Object createInstance() {
        return this.instance;
    }

    public void releaseInstance(Object instance) {
    }

    public Supplier<Object> createSupplier() {
        return () -> this.instance;
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.uri.toString();
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void startInstance(Object instance) {
    }

    public void stopInstance(Object instance) throws Fabric3Exception {
    }

    public void reinject(Object instance) throws Fabric3Exception {
        for (Map.Entry<Supplier, Injectable> entry : this.reinjectionMappings.entrySet()) {
            this.inject(entry.getValue(), entry.getKey());
        }
        this.reinjectionMappings.clear();
    }

    public void addSupplier(Injectable injectable, Supplier supplier, InjectionAttributes attributes) {
        if (InjectableType.REFERENCE == injectable.getType()) {
            this.setFactory(injectable, supplier, attributes);
        } else {
            this.reinjectionMappings.put(supplier, injectable);
        }
    }

    public void removeSupplier(Injectable injectable) {
        Iterator<Map.Entry<Supplier, Injectable>> iterator = this.reinjectionMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Supplier, Injectable> entry = iterator.next();
            if (!injectable.equals((Object)entry.getValue())) continue;
            iterator.remove();
            break;
        }
    }

    public String toString() {
        return "[" + this.uri.toString() + "] in state [" + super.toString() + ']';
    }

    private void initializeInjectionSites(Map<InjectionSite, Injectable> mappings) {
        this.sites = new HashMap<Member, Injectable>();
        for (Map.Entry<InjectionSite, Injectable> entry : mappings.entrySet()) {
            InjectionSite site = entry.getKey();
            if (site instanceof FieldInjectionSite) {
                try {
                    Field field = this.getField(((FieldInjectionSite)site).getName());
                    this.sites.put(field, entry.getValue());
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (!(site instanceof MethodInjectionSite)) continue;
            MethodInjectionSite methodInjectionSite = (MethodInjectionSite)site;
            Method method = methodInjectionSite.getMethod();
            this.sites.put(method, entry.getValue());
        }
    }

    private void setFactory(Injectable injectable, Supplier supplier, InjectionAttributes attributes) {
        Supplier<?> foundSupplier = this.findSupplier(injectable);
        if (foundSupplier == null) {
            Class<?> type = this.getMemberType(injectable);
            if (Map.class.equals(type)) {
                MapMultiplicitySupplier mapFactory = new MapMultiplicitySupplier();
                mapFactory.startUpdate();
                mapFactory.addSupplier(supplier, attributes);
                this.reinjectionMappings.put((Supplier)mapFactory, injectable);
            } else if (Set.class.equals(type)) {
                SetMultiplicitySupplier setFactory = new SetMultiplicitySupplier();
                setFactory.startUpdate();
                setFactory.addSupplier(supplier, attributes);
                this.reinjectionMappings.put((Supplier)setFactory, injectable);
            } else if (List.class.equals(type)) {
                ListMultiplicitySupplier listFactory = new ListMultiplicitySupplier();
                listFactory.startUpdate();
                listFactory.addSupplier(supplier, attributes);
                this.reinjectionMappings.put((Supplier)listFactory, injectable);
            } else if (Collection.class.equals(type)) {
                ListMultiplicitySupplier listFactory = new ListMultiplicitySupplier();
                listFactory.startUpdate();
                listFactory.addSupplier(supplier, attributes);
                this.reinjectionMappings.put((Supplier)listFactory, injectable);
            } else if (type.isArray()) {
                ArrayMultiplicitySupplier arrayFactory = new ArrayMultiplicitySupplier(type.getComponentType());
                arrayFactory.startUpdate();
                arrayFactory.addSupplier(supplier, attributes);
                this.reinjectionMappings.put((Supplier)arrayFactory, injectable);
            } else {
                this.reinjectionMappings.put(supplier, injectable);
            }
        } else if (foundSupplier instanceof MultiplicitySupplier) {
            MultiplicitySupplier multiplicitySupplier = (MultiplicitySupplier)foundSupplier;
            multiplicitySupplier.addSupplier(supplier, attributes);
        } else {
            this.reinjectionMappings.put(supplier, injectable);
        }
    }

    private Supplier<?> findSupplier(Injectable injectable) {
        Supplier supplier = null;
        for (Map.Entry<Supplier, Injectable> entry : this.reinjectionMappings.entrySet()) {
            if (!injectable.equals((Object)entry.getValue())) continue;
            supplier = entry.getKey();
            break;
        }
        return supplier;
    }

    private Class<?> getMemberType(Injectable injectable) {
        for (Map.Entry<Member, Injectable> entry : this.sites.entrySet()) {
            if (!injectable.equals((Object)entry.getValue())) continue;
            Member member = entry.getKey();
            if (member instanceof Method) {
                return ((Method)member).getParameterTypes()[0];
            }
            if (member instanceof Field) {
                return ((Field)member).getType();
            }
            throw new AssertionError((Object)"Unsupported injection site type for singleton components");
        }
        return null;
    }

    private Field getField(String name) throws NoSuchFieldException {
        for (Class<?> clazz = this.instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private void inject(Injectable attribute, Supplier factory) throws Fabric3Exception {
        for (Map.Entry<Member, Injectable> entry : this.sites.entrySet()) {
            Object param;
            if (!entry.getValue().equals((Object)attribute)) continue;
            Member member = entry.getKey();
            if (member instanceof Field) {
                try {
                    param = factory.get();
                    ((Field)member).set(this.instance, param);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new Fabric3Exception((Throwable)e);
                }
            }
            if (member instanceof Method) {
                try {
                    param = factory.get();
                    Method method = (Method)member;
                    method.invoke(this.instance, param);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new Fabric3Exception((Throwable)e);
                }
            }
            throw new Fabric3Exception("Unsupported member type" + member);
        }
    }
}

