/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.system.provision.SystemWireTarget;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.implementation.system.runtime.SystemInvokerInterceptor;
import org.fabric3.spi.container.builder.TargetWireAttacher;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalOperation;
import org.fabric3.spi.model.physical.PhysicalWireSource;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemTargetWireAttacher
implements TargetWireAttacher<SystemWireTarget> {
    private final ComponentManager manager;

    public SystemTargetWireAttacher(@Reference ComponentManager manager) {
        this.manager = manager;
    }

    public void attach(PhysicalWireSource source, SystemWireTarget target, Wire wire) throws Fabric3Exception {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        SystemComponent targetComponent = (SystemComponent)this.manager.getComponent(targetId);
        Class implementationClass = targetComponent.getImplementationClass();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method;
            PhysicalOperation operation = chain.getPhysicalOperation();
            List params = operation.getSourceParameterTypes();
            try {
                method = implementationClass.getMethod(operation.getName(), params.toArray(new Class[params.size()]));
            }
            catch (NoSuchMethodException e) {
                throw new Fabric3Exception("No matching method found", (Throwable)e);
            }
            SystemInvokerInterceptor interceptor = new SystemInvokerInterceptor(method, (AtomicComponent)targetComponent);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public Supplier<?> createSupplier(SystemWireTarget target) throws Fabric3Exception {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        SystemComponent targetComponent = (SystemComponent)this.manager.getComponent(targetId);
        return targetComponent.createSupplier();
    }
}

