/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.component.InvokerEventStreamHandler;
import org.fabric3.implementation.pojo.spi.reflection.ConsumerInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.system.provision.SystemConnectionTarget;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.container.builder.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.FilterHandler;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalConnectionSource;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemTargetConnectionAttacher
implements TargetConnectionAttacher<SystemConnectionTarget> {
    private ComponentManager manager;
    private ReflectionFactory reflectionFactory;

    public SystemTargetConnectionAttacher(@Reference ComponentManager manager, @Reference ReflectionFactory reflectionFactory) {
        this.manager = manager;
        this.reflectionFactory = reflectionFactory;
    }

    public void attach(PhysicalConnectionSource source, SystemConnectionTarget target, ChannelConnection connection) {
        URI targetUri = target.getUri();
        URI targetName = UriHelper.getDefragmentedName((URI)targetUri);
        SystemComponent component = (SystemComponent)this.manager.getComponent(targetName);
        if (component == null) {
            throw new Fabric3Exception("Target component not found: " + targetName);
        }
        ClassLoader loader = target.getClassLoader();
        Method method = (Method)target.getConsumerObject();
        ConsumerInvoker invoker = this.reflectionFactory.createConsumerInvoker(method);
        EventStream stream = connection.getEventStream();
        Class type = connection.getEventStream().getEventType();
        if (!Object.class.equals((Object)type)) {
            stream.addHandler((EventStreamHandler)new FilterHandler(type));
        }
        InvokerEventStreamHandler handler = new InvokerEventStreamHandler(invoker, (AtomicComponent)component, loader);
        stream.addHandler((EventStreamHandler)handler);
    }

    public void detach(PhysicalConnectionSource source, SystemConnectionTarget target) {
    }
}

