/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.implementation.pojo.builder.PojoSourceWireAttacher;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.implementation.system.provision.SystemWireSource;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.container.builder.SourceWireAttacher;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemSourceWireAttacher
extends PojoSourceWireAttacher
implements SourceWireAttacher<SystemWireSource> {
    private final ComponentManager manager;
    private WireProxyService proxyService;

    public SystemSourceWireAttacher(@Reference ComponentManager manager, @Reference TransformerRegistry transformerRegistry) {
        super(transformerRegistry);
        this.manager = manager;
    }

    @Reference(required=false)
    public void setProxyService(WireProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public void attach(SystemWireSource source, PhysicalWireTarget target, Wire wire) {
        if (this.proxyService == null) {
            throw new Fabric3Exception("Attempt to inject a non-optimized wire during runtime bootstrap.");
        }
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        Class type = source.getInterfaceClass();
        if (InjectableType.CALLBACK.equals((Object)injectable.getType())) {
            throw new UnsupportedOperationException("Callbacks are not supported on system components");
        }
        String callbackUri = null;
        URI uri = target.getCallbackUri();
        if (uri != null) {
            callbackUri = uri.toString();
        }
        Supplier factory = this.proxyService.createSupplier(type, wire, callbackUri);
        if (source.isKeyed() || source.isOrdered()) {
            Object key = this.getKey(source, target);
            int order = source.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            component.setSupplier(injectable, factory, attributes);
        } else {
            component.setSupplier(injectable, factory);
        }
    }

    public void detach(SystemWireSource source, PhysicalWireTarget target) {
        this.detachSupplier(source, target);
    }

    public void detachSupplier(SystemWireSource source, PhysicalWireTarget target) {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeSupplier(injectable);
    }

    public void attachSupplier(SystemWireSource source, Supplier<?> supplier, PhysicalWireTarget target) {
        URI sourceId = UriHelper.getDefragmentedName((URI)source.getUri());
        SystemComponent component = (SystemComponent)this.manager.getComponent(sourceId);
        Injectable injectable = source.getInjectable();
        if (source.isKeyed() || source.isOrdered()) {
            Object key = this.getKey(source, target);
            int order = source.getOrder();
            InjectionAttributes attributes = new InjectionAttributes(key, order);
            component.setSupplier(injectable, supplier, attributes);
        } else {
            component.setSupplier(injectable, supplier);
        }
    }
}

