/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Scope;
import org.fabric3.implementation.pojo.builder.PojoComponentBuilder;
import org.fabric3.implementation.pojo.builder.PropertySupplierBuilder;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactoryBuilder;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.system.provision.PhysicalSystemComponent;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.component.ScopeContainer;
import org.fabric3.spi.container.component.ScopeRegistry;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class SystemComponentBuilder
extends PojoComponentBuilder<PhysicalSystemComponent, SystemComponent> {
    private ScopeRegistry scopeRegistry;
    private ImplementationManagerFactoryBuilder factoryBuilder;

    public SystemComponentBuilder(@Reference ScopeRegistry scopeRegistry, @Reference ImplementationManagerFactoryBuilder factoryBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference PropertySupplierBuilder propertyBuilder, @Reference ManagementService managementService, @Reference IntrospectionHelper helper, @Reference HostInfo info) {
        super(propertyBuilder, managementService, helper, info);
        this.scopeRegistry = scopeRegistry;
        this.factoryBuilder = factoryBuilder;
    }

    public SystemComponent build(PhysicalSystemComponent physicalComponent) throws Fabric3Exception {
        URI uri = physicalComponent.getComponentUri();
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        ImplementationManagerDefinition managerDefinition = physicalComponent.getFactoryDefinition();
        ImplementationManagerFactory factory = this.factoryBuilder.build(managerDefinition);
        boolean eager = physicalComponent.isEagerInit();
        URI contributionUri = physicalComponent.getContributionUri();
        SystemComponent component = new SystemComponent(uri, factory, scopeContainer, eager, contributionUri);
        this.createPropertyFactories(physicalComponent, component, factory);
        this.export(physicalComponent, (AtomicComponent)component);
        return component;
    }

    public void dispose(PhysicalSystemComponent physicalComponent, SystemComponent component) throws Fabric3Exception {
        this.dispose(physicalComponent);
    }
}

