/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.reflection.jdk;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;

public class ReflectiveSupplier<T>
implements Supplier<T> {
    private final Constructor<T> constructor;
    private final Supplier<?>[] paramFactories;

    public ReflectiveSupplier(Constructor<T> constructor, Supplier<?>[] paramFactories) {
        this.constructor = constructor;
        this.paramFactories = paramFactories;
    }

    @Override
    public T get() throws Fabric3Exception {
        try {
            if (this.paramFactories == null) {
                return this.constructor.newInstance(new Object[0]);
            }
            Object[] params = new Object[this.paramFactories.length];
            for (int i = 0; i < this.paramFactories.length; ++i) {
                Supplier<?> paramFactory = this.paramFactories[i];
                params[i] = paramFactory.get();
            }
            try {
                return this.constructor.newInstance(params);
            }
            catch (IllegalArgumentException e) {
                Class<?>[] paramTypes = this.constructor.getParameterTypes();
                String name = this.constructor.toString();
                for (int i = 0; i < paramTypes.length; ++i) {
                    Class<?> paramType = paramTypes[i];
                    if (paramType.isPrimitive() && params[i] == null) {
                        throw new Fabric3Exception("Cannot assign null value to primitive for parameter " + i + " of " + name);
                    }
                    if (params[i] == null || paramType.isInstance(params[i])) continue;
                    throw new Fabric3Exception("Unable to assign parameter of type " + params[i].getClass().getName() + " to parameter " + i + " of " + name);
                }
                throw new Fabric3Exception(name, (Throwable)e);
            }
        }
        catch (InstantiationException e) {
            String name = this.constructor.getDeclaringClass().getName();
            throw new AssertionError((Object)("Class is not instantiable:" + name));
        }
        catch (IllegalAccessException e) {
            String id = this.constructor.toString();
            throw new AssertionError((Object)("Constructor is not accessible: " + id));
        }
        catch (InvocationTargetException e) {
            String id = this.constructor.toString();
            throw new Fabric3Exception("Exception thrown by constructor: " + id, e.getCause());
        }
    }
}

