/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.proxy.jdk.wire.JDKWireProxyService;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.InvocationChain;

public class CallbackWireSupplier<T>
implements Supplier<T> {
    private Class<T> interfaze;
    private boolean multiThreaded;
    private JDKWireProxyService proxyService;
    private Map<String, Map<Method, InvocationChain>> mappings;
    private Map<Method, InvocationChain> singleMapping;

    public CallbackWireSupplier(Class<T> interfaze, boolean multiThreaded, JDKWireProxyService proxyService, Map<String, Map<Method, InvocationChain>> mappings) {
        this.interfaze = interfaze;
        this.multiThreaded = multiThreaded;
        this.proxyService = proxyService;
        this.mappings = mappings;
        if (mappings.size() == 1) {
            this.singleMapping = mappings.values().iterator().next();
        }
    }

    @Override
    public T get() throws Fabric3Exception {
        if (this.multiThreaded) {
            return this.interfaze.cast(this.proxyService.createMultiThreadedCallbackProxy(this.interfaze, this.mappings));
        }
        String callbackReference = WorkContextCache.getThreadWorkContext().peekCallbackReference();
        Map<Method, InvocationChain> mapping = this.singleMapping != null ? this.singleMapping : this.mappings.get(callbackReference);
        return this.interfaze.cast(this.proxyService.createCallbackProxy(this.interfaze, mapping));
    }

    public void updateMappings(String callbackUri, Map<Method, InvocationChain> chains) {
        this.mappings.put(callbackUri, chains);
        this.singleMapping = this.mappings.size() == 1 ? this.mappings.values().iterator().next() : null;
    }
}

