/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.supplier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.fabric3.implementation.pojo.supplier.FactoryState;
import org.fabric3.implementation.pojo.supplier.MultiplicitySupplier;
import org.fabric3.spi.container.injection.InjectionAttributes;

public abstract class AbstractCollectionMultiplicitySupplier<T extends Collection<Supplier<?>>>
implements MultiplicitySupplier<Object> {
    private static final Comparator<Map.Entry<Supplier<?>, InjectionAttributes>> COMPARATOR = (first, second) -> ((InjectionAttributes)first.getValue()).getOrder() - ((InjectionAttributes)second.getValue()).getOrder();
    protected volatile List<Supplier<?>> suppliers = new ArrayList();
    private LinkedHashMap<Supplier<?>, InjectionAttributes> temporarySuppliers;
    private FactoryState state = FactoryState.UPDATED;

    @Override
    public void addSupplier(Supplier<?> supplier, InjectionAttributes injectionAttributes) {
        if (this.state != FactoryState.UPDATING) {
            throw new IllegalStateException("Factory not in updating state. The method startUpdate() must be called first.");
        }
        this.temporarySuppliers.put(supplier, injectionAttributes);
    }

    @Override
    public void clear() {
        this.suppliers.clear();
    }

    @Override
    public void startUpdate() {
        this.state = FactoryState.UPDATING;
        this.temporarySuppliers = new LinkedHashMap();
    }

    @Override
    public void endUpdate() {
        if (this.temporarySuppliers != null && !this.temporarySuppliers.isEmpty()) {
            this.suppliers = this.sortTemporaryFactories(this.temporarySuppliers);
            this.temporarySuppliers = null;
        }
        this.state = FactoryState.UPDATED;
    }

    private List<Supplier<?>> sortTemporaryFactories(LinkedHashMap<Supplier<?>, InjectionAttributes> factories) {
        ArrayList entries = new ArrayList(factories.entrySet());
        Collections.sort(entries, COMPARATOR);
        return entries.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

