/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.proxy;

import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyService;
import org.fabric3.implementation.pojo.spi.proxy.WireProxyServiceExtension;
import org.fabric3.spi.container.wire.Wire;
import org.oasisopen.sca.annotation.Reference;

public class WireProxyServiceImpl
implements WireProxyService {
    private WireProxyServiceExtension extension;

    @Reference(required=false)
    public void setExtensions(List<WireProxyServiceExtension> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        if (extensions.size() == 1) {
            this.extension = extensions.get(0);
        } else {
            if (this.extension != null && !this.extension.isDefault()) {
                return;
            }
            for (WireProxyServiceExtension entry : extensions) {
                if (entry.isDefault()) continue;
                this.extension = entry;
                return;
            }
        }
    }

    @Override
    public <T> Supplier<T> createSupplier(Class<T> interfaze, Wire wire, String callbackUri) {
        this.checkExtension();
        return this.extension.createSupplier(interfaze, wire, callbackUri);
    }

    @Override
    public <T> Supplier<T> createCallbackSupplier(Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) {
        this.checkExtension();
        return this.extension.createCallbackSupplier(interfaze, multiThreaded, callbackUri, wire);
    }

    @Override
    public <T> Supplier<?> updateCallbackSupplier(Supplier<?> supplier, Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) {
        this.checkExtension();
        return this.extension.updateCallbackSupplier(supplier, interfaze, multiThreaded, callbackUri, wire);
    }

    private void checkExtension() {
        if (this.extension == null) {
            throw new Fabric3Exception("Channel proxy service extension not installed");
        }
    }
}

