/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.manager;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.implementation.pojo.manager.ImplementationManager;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.spi.container.injection.Injector;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;

public class ImplementationManagerImpl
implements ImplementationManager {
    private final Supplier<?> constructor;
    private Injectable[] injectables;
    private final Injector<Object>[] injectors;
    private final LifecycleInvoker initInvoker;
    private final LifecycleInvoker destroyInvoker;
    private final ClassLoader cl;
    private final boolean reinjectable;
    private Set<Injector<Object>> updatedInjectors;

    public ImplementationManagerImpl(Supplier<?> constructor, Injectable[] injectables, Injector<Object>[] injectors, LifecycleInvoker initInvoker, LifecycleInvoker destroyInvoker, boolean reinjectable, ClassLoader cl) {
        this.constructor = constructor;
        this.injectables = injectables;
        this.injectors = injectors;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.reinjectable = reinjectable;
        this.cl = cl;
        this.updatedInjectors = reinjectable ? new HashSet<Injector<Object>>() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object newInstance() throws Fabric3Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Message message = MessageCache.getMessage();
            Object content = message.getBody();
            Object instance = this.constructor.get();
            if (this.injectors != null) {
                for (Injector<Object> injector : this.injectors) {
                    injector.inject(instance);
                }
            }
            message.setBody(content);
            Object obj = instance;
            return obj;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    @Override
    public void start(Object instance) throws Fabric3Exception {
        if (this.initInvoker != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.cl);
                this.initInvoker.invoke(instance);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }

    @Override
    public void stop(Object instance) throws Fabric3Exception {
        if (this.destroyInvoker != null) {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.cl);
                this.destroyInvoker.invoke(instance);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }

    @Override
    public void reinject(Object instance) throws Fabric3Exception {
        if (!this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable:" + instance.getClass().getName());
        }
        for (Injector<Object> injector : this.updatedInjectors) {
            injector.inject(instance);
        }
        this.updatedInjectors.clear();
    }

    @Override
    public void updated(Object instance, String name) {
        if (instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable: " + instance.getClass().getName());
        }
        for (int i = 0; i < this.injectables.length; ++i) {
            Injectable attribute = this.injectables[i];
            if (!attribute.getName().equals(name)) continue;
            Injector<Object> injector = this.injectors[i];
            if (instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }

    @Override
    public void removed(Object instance, String name) {
        if (instance != null && !this.reinjectable) {
            throw new IllegalStateException("Implementation is not reinjectable: " + instance.getClass().getName());
        }
        for (int i = 0; i < this.injectables.length; ++i) {
            Injectable attribute = this.injectables[i];
            if (!attribute.getName().equals(name)) continue;
            Injector<Object> injector = this.injectors[i];
            injector.clearSupplier();
            if (instance == null) continue;
            this.updatedInjectors.add(injector);
        }
    }
}

