/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.manager;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.fabric3.api.model.type.java.Injectable;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.implementation.pojo.manager.ImplementationManager;
import org.fabric3.implementation.pojo.manager.ImplementationManagerFactory;
import org.fabric3.implementation.pojo.manager.ImplementationManagerImpl;
import org.fabric3.implementation.pojo.spi.reflection.LifecycleInvoker;
import org.fabric3.implementation.pojo.spi.reflection.ReflectionFactory;
import org.fabric3.implementation.pojo.supplier.ArrayMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.ListMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.MapMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.MultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.SetMultiplicitySupplier;
import org.fabric3.implementation.pojo.supplier.UpdatableSupplier;
import org.fabric3.spi.container.injection.InjectionAttributes;
import org.fabric3.spi.container.injection.Injector;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

public class ImplementationManagerFactoryImpl
implements ImplementationManagerFactory {
    private static final Supplier<?> NULL_FACTORY = () -> null;
    private final Class<?> implementationClass;
    private final Constructor<?> constructor;
    private final List<Injectable> cdiSources;
    private final Map<InjectionSite, Injectable> postConstruction;
    private final LifecycleInvoker initInvoker;
    private final LifecycleInvoker destroyInvoker;
    private final boolean reinjectable;
    private final ClassLoader cl;
    private ReflectionFactory reflectionFactory;
    private final Map<Injectable, Supplier<?>> factories;

    public ImplementationManagerFactoryImpl(Constructor<?> constructor, List<Injectable> cdiSources, Map<InjectionSite, Injectable> postConstruction, LifecycleInvoker initInvoker, LifecycleInvoker destroyInvoker, boolean reinjectable, ClassLoader cl, ReflectionFactory reflectionFactory) {
        this.reflectionFactory = reflectionFactory;
        this.implementationClass = constructor.getDeclaringClass();
        this.constructor = constructor;
        this.cdiSources = cdiSources;
        this.postConstruction = postConstruction;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.reinjectable = reinjectable;
        this.cl = cl;
        this.factories = new HashMap();
    }

    @Override
    public ImplementationManager createManager() {
        Supplier<?> factory = this.reflectionFactory.createInstantiator(this.constructor, this.getConstructorParameterSuppliers(this.cdiSources));
        Map<Injectable, Injector<?>> mappings = this.createInjectorMappings();
        Injectable[] attributes = mappings.keySet().toArray(new Injectable[mappings.size()]);
        Injector[] injectors = mappings.values().toArray(new Injector[mappings.size()]);
        return new ImplementationManagerImpl(factory, attributes, injectors, this.initInvoker, this.destroyInvoker, this.reinjectable, this.cl);
    }

    @Override
    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public void startUpdate() {
        for (Map.Entry<Injectable, Supplier<?>> entry : this.factories.entrySet()) {
            Injectable injectable = entry.getKey();
            Supplier<?> factory = entry.getValue();
            if (InjectableType.REFERENCE != injectable.getType() && InjectableType.CALLBACK != injectable.getType() || !(factory instanceof MultiplicitySupplier)) continue;
            MultiplicitySupplier multiplicitySupplier = (MultiplicitySupplier)factory;
            multiplicitySupplier.startUpdate();
        }
    }

    @Override
    public void endUpdate() {
        for (Map.Entry<Injectable, Supplier<?>> entry : this.factories.entrySet()) {
            Injectable injectable = entry.getKey();
            Supplier<?> factory = entry.getValue();
            if (InjectableType.REFERENCE != injectable.getType() && InjectableType.CALLBACK != injectable.getType() || !(factory instanceof MultiplicitySupplier)) continue;
            MultiplicitySupplier multiplicitySupplier = (MultiplicitySupplier)factory;
            multiplicitySupplier.endUpdate();
        }
    }

    @Override
    public void setSupplier(Injectable injectable, Supplier<?> supplier) {
        this.setSupplier(injectable, supplier, InjectionAttributes.EMPTY_ATTRIBUTES);
    }

    @Override
    public void setSupplier(Injectable injectable, Supplier<?> supplier, InjectionAttributes attributes) {
        if (InjectableType.REFERENCE == injectable.getType() || InjectableType.CALLBACK == injectable.getType()) {
            this.setUpdatableFactory(injectable, supplier, attributes);
        } else {
            Supplier<?> factory = this.factories.get(injectable);
            if (factory instanceof UpdatableSupplier) {
                ((UpdatableSupplier)factory).update(supplier);
            } else {
                this.factories.put(injectable, supplier);
            }
        }
    }

    @Override
    public Supplier<?> getObjectSupplier(Injectable injectable) {
        return this.factories.get(injectable);
    }

    @Override
    public void removeSupplier(Injectable injectable) {
        this.factories.remove(injectable);
    }

    @Override
    public Class<?> getMemberType(Injectable injectable) {
        InjectionSite site = this.findInjectionSite(injectable);
        if (site == null) {
            throw new AssertionError((Object)("No injection site for " + injectable + " in " + this.implementationClass));
        }
        if (site instanceof FieldInjectionSite) {
            try {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = this.getField(fieldSite.getName());
                return field.getType();
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof MethodInjectionSite) {
            MethodInjectionSite methodSite = (MethodInjectionSite)site;
            Method method = methodSite.getMethod();
            return method.getParameterTypes()[methodSite.getParam()];
        }
        if (site instanceof ConstructorInjectionSite) {
            ConstructorInjectionSite methodSite = (ConstructorInjectionSite)site;
            Constructor method = methodSite.getConstructor();
            return method.getParameterTypes()[methodSite.getParam()];
        }
        throw new AssertionError((Object)("Invalid injection site type: " + site.getClass()));
    }

    @Override
    public Type getGenericType(Injectable injectable) {
        InjectionSite site = this.findInjectionSite(injectable);
        if (site == null) {
            throw new AssertionError((Object)("No injection site for " + injectable + " in " + this.implementationClass));
        }
        if (site instanceof FieldInjectionSite) {
            try {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = this.getField(fieldSite.getName());
                return field.getGenericType();
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (site instanceof MethodInjectionSite) {
            MethodInjectionSite methodSite = (MethodInjectionSite)site;
            Method method = methodSite.getMethod();
            return method.getGenericParameterTypes()[methodSite.getParam()];
        }
        if (site instanceof ConstructorInjectionSite) {
            ConstructorInjectionSite methodSite = (ConstructorInjectionSite)site;
            Constructor method = methodSite.getConstructor();
            return method.getGenericParameterTypes()[methodSite.getParam()];
        }
        throw new AssertionError((Object)("Invalid injection site type " + site.getClass()));
    }

    protected Supplier<?>[] getConstructorParameterSuppliers(List<Injectable> sources) {
        Supplier[] argumentFactories = new Supplier[sources.size()];
        for (int i = 0; i < argumentFactories.length; ++i) {
            Injectable source = sources.get(i);
            Supplier<?> factory = this.factories.get(source);
            if (factory == null) {
                factory = NULL_FACTORY;
            }
            argumentFactories[i] = factory;
        }
        return argumentFactories;
    }

    protected Map<Injectable, Injector<?>> createInjectorMappings() {
        LinkedHashMap injectors = new LinkedHashMap(this.postConstruction.size());
        for (Map.Entry<InjectionSite, Injectable> entry : this.postConstruction.entrySet()) {
            Injector<?> injector;
            InjectionSite site = entry.getKey();
            Injectable attribute = entry.getValue();
            InjectableType type = attribute.getType();
            Supplier<?> supplier = this.factories.get(attribute);
            if (supplier == null && (type == InjectableType.REFERENCE || type == InjectableType.CALLBACK)) {
                supplier = this.createSupplier(site.getType());
                this.factories.put(attribute, supplier);
            }
            if (supplier == null) continue;
            if (site instanceof FieldInjectionSite) {
                try {
                    FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                    Field field = this.getField(fieldSite.getName());
                    injector = this.reflectionFactory.createInjector(field, supplier);
                    injectors.put(attribute, injector);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (!(site instanceof MethodInjectionSite)) continue;
            MethodInjectionSite methodSite = (MethodInjectionSite)site;
            Method method = methodSite.getMethod();
            injector = this.reflectionFactory.createInjector(method, supplier);
            injectors.put(attribute, injector);
        }
        return injectors;
    }

    private void setUpdatableFactory(Injectable injectable, Supplier<?> supplier, InjectionAttributes attributes) {
        Supplier<?> factory = this.factories.get(injectable);
        if (factory == null) {
            Class<?> type = this.getMemberType(injectable);
            if (Map.class.equals(type)) {
                MapMultiplicitySupplier mapFactory = new MapMultiplicitySupplier();
                mapFactory.startUpdate();
                mapFactory.addSupplier(supplier, attributes);
                this.factories.put(injectable, mapFactory);
            } else if (Set.class.equals(type)) {
                SetMultiplicitySupplier setFactory = new SetMultiplicitySupplier();
                setFactory.startUpdate();
                setFactory.addSupplier(supplier, attributes);
                this.factories.put(injectable, setFactory);
            } else if (List.class.equals(type)) {
                ListMultiplicitySupplier listFactory = new ListMultiplicitySupplier();
                listFactory.startUpdate();
                listFactory.addSupplier(supplier, attributes);
                this.factories.put(injectable, listFactory);
            } else if (Collection.class.equals(type)) {
                ListMultiplicitySupplier listFactory = new ListMultiplicitySupplier();
                listFactory.startUpdate();
                listFactory.addSupplier(supplier, attributes);
                this.factories.put(injectable, listFactory);
            } else if (type.isArray()) {
                ArrayMultiplicitySupplier arrayFactory = new ArrayMultiplicitySupplier(type.getComponentType());
                arrayFactory.startUpdate();
                arrayFactory.addSupplier(supplier, attributes);
                this.factories.put(injectable, arrayFactory);
            } else {
                this.factories.put(injectable, supplier);
            }
        } else if (factory instanceof MultiplicitySupplier) {
            MultiplicitySupplier multiplicitySupplier = (MultiplicitySupplier)factory;
            multiplicitySupplier.addSupplier(supplier, attributes);
        } else {
            this.factories.put(injectable, supplier);
        }
    }

    private InjectionSite findInjectionSite(Injectable attribute) {
        for (int i = 0; i < this.cdiSources.size(); ++i) {
            Injectable injectable = this.cdiSources.get(i);
            if (!attribute.equals((Object)injectable)) continue;
            return new ConstructorInjectionSite(this.constructor, i);
        }
        for (Map.Entry<InjectionSite, Injectable> entry : this.postConstruction.entrySet()) {
            if (!entry.getValue().equals((Object)attribute)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Field getField(String name) throws NoSuchFieldException {
        for (Class<?> clazz = this.implementationClass; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private Supplier<?> createSupplier(Class<?> referenceType) {
        if (Map.class.equals(referenceType)) {
            return new MapMultiplicitySupplier();
        }
        if (Set.class.equals(referenceType)) {
            return new SetMultiplicitySupplier();
        }
        if (List.class.equals(referenceType)) {
            return new ListMultiplicitySupplier();
        }
        if (Collection.class.equals(referenceType)) {
            return new ListMultiplicitySupplier();
        }
        return NULL_FACTORY;
    }
}

