/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.component;

import java.lang.reflect.InvocationTargetException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.implementation.pojo.spi.reflection.ServiceInvoker;
import org.fabric3.spi.container.component.AtomicComponent;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationRuntimeException;

public class InvokerInterceptor
implements Interceptor {
    private ServiceInvoker invoker;
    private AtomicComponent component;
    private ClassLoader targetTCCLClassLoader;

    public InvokerInterceptor(ServiceInvoker invoker, AtomicComponent component) {
        this.invoker = invoker;
        this.component = component;
    }

    public InvokerInterceptor(ServiceInvoker invoker, AtomicComponent component, ClassLoader targetTCCLClassLoader) {
        this.invoker = invoker;
        this.component = component;
        this.targetTCCLClassLoader = targetTCCLClassLoader;
    }

    public void setNext(Interceptor next) {
        throw new IllegalStateException("This interceptor must be the last one in an target interceptor chain");
    }

    public Interceptor getNext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        Object instance;
        try {
            instance = this.component.getInstance();
        }
        catch (Fabric3Exception e) {
            throw new InvocationRuntimeException((Throwable)e);
        }
        try {
            Message message = this.invoke(msg, instance);
            return message;
        }
        finally {
            try {
                this.component.releaseInstance(instance);
            }
            catch (Fabric3Exception e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message invoke(Message msg, Object instance) {
        block7: {
            try {
                Object body = msg.getBody();
                if (this.targetTCCLClassLoader == null) {
                    msg.setBody(this.invoker.invoke(instance, body));
                    break block7;
                }
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.targetTCCLClassLoader);
                    msg.setBody(this.invoker.invoke(instance, body));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (InvocationTargetException e) {
                msg.setBodyWithFault((Object)e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new InvocationRuntimeException((Throwable)e);
            }
        }
        return msg;
    }
}

