/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.util.ArrayList;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.implementation.pojo.provision.PojoWireSource;
import org.fabric3.spi.model.physical.PhysicalWireTarget;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.ClassLoading;

public abstract class PojoSourceWireAttacher {
    protected TransformerRegistry transformerRegistry;

    protected PojoSourceWireAttacher(TransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    protected Object getKey(PojoWireSource source, PhysicalWireTarget target) throws Fabric3Exception {
        if (!source.isKeyed()) {
            return null;
        }
        String key = source.getKey();
        ClassLoader targetClassLoader = target.getClassLoader();
        Class keyType = ClassLoading.loadClass((ClassLoader)targetClassLoader, (String)source.getKeyClassName());
        if (String.class.equals((Object)keyType)) {
            return key;
        }
        if (Enum.class.isAssignableFrom(keyType)) {
            Class enumClass = keyType;
            return Enum.valueOf(enumClass, key);
        }
        JavaType targetType = new JavaType(keyType);
        return this.createKey((DataType)targetType, key, targetClassLoader);
    }

    private Object createKey(DataType targetType, String value, ClassLoader classLoader) throws Fabric3Exception {
        Class type = targetType.getType();
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(type);
        Transformer transformer = this.transformerRegistry.getTransformer(TypeConstants.STRING_TYPE, targetType, types, types);
        if (transformer == null) {
            throw new Fabric3Exception("No transformer for : " + targetType);
        }
        return transformer.transform((Object)value, classLoader);
    }
}

