/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.implementation.pojo.builder.AbstractPropertyBuilder;
import org.fabric3.implementation.pojo.builder.MapBuilder;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapBuilderImpl
extends AbstractPropertyBuilder
implements MapBuilder {
    private DocumentBuilder documentBuilder;

    public MapBuilderImpl(@Reference TransformerRegistry registry) {
        super(registry);
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Supplier<Map> createSupplier(String name, JavaGenericType type, Document value, ClassLoader classLoader) {
        List typeInfos = type.getTypeInfo().getParameterTypesInfos();
        if (typeInfos.size() < 2) {
            throw new Fabric3Exception("Map properties must have a key and value type");
        }
        Class keyType = ((JavaTypeInfo)typeInfos.get(0)).getRawType();
        ArrayList keyTypes = new ArrayList();
        keyTypes.add(keyType);
        Class valueType = ((JavaTypeInfo)type.getTypeInfo().getParameterTypesInfos().get(1)).getRawType();
        ArrayList valueTypes = new ArrayList();
        valueTypes.add(valueType);
        Transformer keyTransformer = this.getTransformer(name, TypeConstants.PROPERTY_TYPE, (DataType)new JavaType(keyType), keyTypes);
        Transformer valueTransformer = this.getTransformer(name, TypeConstants.PROPERTY_TYPE, (DataType)new JavaType(valueType), valueTypes);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Element root = value.getDocumentElement();
        Element topValue = this.normalizeValues(root);
        if (topValue == null) {
            throw new Fabric3Exception("Invalid Map format: no top-level value tag for " + name);
        }
        NodeList keys = topValue.getElementsByTagName("key");
        NodeList values = topValue.getElementsByTagName("value");
        if (keys.getLength() != values.getLength()) {
            throw new Fabric3Exception("Invalid Map format: keys and values must be the same length for " + name);
        }
        if (keys.getLength() == 0) {
            throw new Fabric3Exception("Invalid Map format: there must be a key and value node for property " + name);
        }
        for (int i = 0; i < keys.getLength(); ++i) {
            Element keyNode = (Element)keys.item(i);
            Element valNode = (Element)values.item(i);
            Object key = keyTransformer.transform((Object)keyNode, classLoader);
            Object val = valueTransformer.transform((Object)valNode, classLoader);
            map.put(key, val);
        }
        return () -> map;
    }

    private Element normalizeValues(Element root) {
        NodeList nodes = root.getChildNodes();
        if (nodes.getLength() == 0) {
            return null;
        }
        if (nodes.getLength() == 1) {
            if (nodes.item(0).getNodeName().equals("value")) {
                return (Element)nodes.item(0);
            }
            return null;
        }
        ArrayList<Element> entries = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!nodes.item(i).getNodeName().equals("value")) continue;
            entries.add((Element)nodes.item(i).getFirstChild());
        }
        if (entries.isEmpty()) {
            return null;
        }
        Document document = this.documentBuilder.newDocument();
        Element newRoot = document.createElement("value");
        document.appendChild(newRoot);
        for (Element entry : entries) {
            document.adoptNode(entry);
            newRoot.appendChild(entry);
        }
        return newRoot;
    }
}

