/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.implementation.pojo.builder.JsonObjectBuilder;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;

public class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private static final DataType JSON_TYPE = new JavaType(String.class, "JSON");
    private TransformerRegistry transformerRegistry;

    public JsonObjectBuilderImpl(@Reference TransformerRegistry transformerRegistry) {
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    public Supplier<?> createSupplier(String name, String value, DataType dataType, ClassLoader classLoader) throws Fabric3Exception {
        Class type = dataType.getType();
        if (dataType.getType().equals(String.class) || value == null) {
            return () -> value;
        }
        ArrayList<Class> types = new ArrayList<Class>();
        types.add(type);
        Transformer transformer = this.transformerRegistry.getTransformer(JSON_TYPE, dataType, types, types);
        if (transformer == null) {
            throw new Fabric3Exception("No transformer for property " + name + " of type: " + type);
        }
        Object instance = transformer.transform((Object)value, classLoader);
        return () -> instance;
    }
}

