/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.pojo.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.implementation.pojo.builder.AbstractPropertyBuilder;
import org.fabric3.implementation.pojo.builder.ArrayBuilder;
import org.fabric3.spi.model.physical.ParamTypes;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.Transformer;
import org.fabric3.spi.transform.TransformerRegistry;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArrayBuilderImpl
extends AbstractPropertyBuilder
implements ArrayBuilder {
    public ArrayBuilderImpl(@Reference TransformerRegistry registry) {
        super(registry);
    }

    @Override
    public Supplier<?> createSupplier(String name, DataType dataType, Document value, ClassLoader classLoader) {
        Class componentType = dataType.getType().getComponentType();
        Class type = componentType;
        if (type.isPrimitive()) {
            type = (Class)ParamTypes.PRIMITIVE_TO_OBJECT.get(type);
        }
        ArrayList types = new ArrayList();
        types.add(type);
        Transformer transformer = this.getTransformer(name, TypeConstants.PROPERTY_TYPE, (DataType)new JavaType(type), types);
        Element root = value.getDocumentElement();
        NodeList nodes = root.getChildNodes();
        Object array = Array.newInstance(componentType, nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i).getFirstChild();
            Object val = transformer.transform((Object)node, classLoader);
            Array.set(array, i, val);
        }
        return () -> array;
    }
}

