/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.transform.Transformer;

public class String2JAXBElementTransformer
implements Transformer<String, Object> {
    private JAXBContext jaxbContext;
    private Class<?> declaredType;

    public String2JAXBElementTransformer(JAXBContext jaxbContext, Class<?> declaredType) {
        this.jaxbContext = jaxbContext;
        this.declaredType = declaredType;
    }

    public Object transform(String source, ClassLoader loader) throws Fabric3Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            StringReader reader = new StringReader(source);
            StreamSource streamSource = new StreamSource(reader);
            Object object = this.jaxbContext.createUnmarshaller().unmarshal((Source)streamSource, this.declaredType).getValue();
            return object;
        }
        catch (JAXBException e) {
            throw new Fabric3Exception((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

