/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.transform.Transformer;
import org.w3c.dom.Node;

public class Node2JAXBElementTransformer
implements Transformer<Node, Object> {
    private JAXBContext jaxbContext;
    private Class<?> declaredType;

    public Node2JAXBElementTransformer(JAXBContext jaxbContext, Class<?> declaredType) {
        this.jaxbContext = jaxbContext;
        this.declaredType = declaredType;
    }

    public Object transform(Node source, ClassLoader loader) throws Fabric3Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object object = this.jaxbContext.createUnmarshaller().unmarshal(source, this.declaredType).getValue();
            return object;
        }
        catch (JAXBException e) {
            throw new Fabric3Exception((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

