/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.jaxb.transform;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.transform.Transformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JAXBObject2DocumentTransformer
implements Transformer<Object, Document> {
    private JAXBContext jaxbContext;
    private DocumentBuilderFactory factory;

    public JAXBObject2DocumentTransformer(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
    }

    public Document transform(Object source, ClassLoader loader) throws Fabric3Exception {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.marshal(source, (Node)document);
            return document;
        }
        catch (JAXBException | ParserConfigurationException e) {
            throw new Fabric3Exception(e);
        }
    }
}

